<?php
include_once('../common/base.php');


$initOutput=isset($config['parameters']['outputs_init'])?$config['parameters']['outputs_init']:0;
if(empty($initOutput)){
    $initOutput=0;
}

$respone=array();
$departmentid=$config['work_order']['producing_department'];
$workcenters=$config['work_order']['workcenters'];
$producingLines=$config['work_order']['producing_lines'];
$is_producing_line=$config['work_order']['is_producing_line'];



$starttime=date('Y-m-d 0:0:0');
$endtime=date('Y-m-d H:i:s');
$todaystart=date('Y-m-d 00:00:00');
$todayend=date('Y-m-d 00:00:00', strtotime('next day'));
$fistDayOfThisYear=date('Y-m-d 00:00:00', strtotime('first day of this year'));
switch ($config['work_order']['plan_search_mode']) {
    //2:看3日计划
    case '2':
        $starttime=date('Y-m-d 00:00:00');
        $endtime=date('Y-m-d 00:00:00', strtotime('+3 day'));
        break;
    //3:查本周计划
    case '3':
        $starttime=date('Y-m-d 00:00:00', strtotime('Monday this week'));
        $endtime=date('Y-m-d 00:00:00', strtotime('Monday next week '));
        break;
    //4:查本月计划
    case '4':
        $starttime=date('Y-m-d 00:00:00', strtotime('first day of this month'));
        $endtime=date('Y-m-d 00:00:00', strtotime('first day of next month'));
        break;
    
    //默认仅查当日
    default:
        $starttime=date('Y-m-d 00:00:00');
        $endtime=date('Y-m-d 00:00:00', strtotime('next day'));
}



//今日目标kpi数值
if($config['parameters']['target_kpi_autocompute']=='0'){
    $sql_kpi_today_target="SELECT [TargetValue]  FROM [dbo].[KPI] WHERE [dbo].[KPI].[KpiNo]='".$config['parameters']['today_target_kpi_boundary']."'";

    $stmt=sqlsrv_query($conn, $sql_kpi_today_target);
    $kpi_today_target=0;
    if ($stmt) {
        $row=sqlsrv_fetch_array($stmt, SQLSRV_FETCH_NUMERIC);
        $kpi_today_target=$row[0];
        sqlsrv_free_stmt($stmt);
    }
}else{
    if ($is_producing_line==1) {
        $sql_tdata="SELECT sum(ProcessWork.InputNum) FROM [dbo].[ProcessWork] INNER JOIN [dbo].[ProduceFormM] ON [dbo].[ProcessWork].[PFormMId] = [dbo].[ProduceFormM].[PFormMId] ";
        $sql_tdata.=" LEFT JOIN [dbo].[Department] ON [dbo].[Department].[DepId]=[dbo].[ProcessWork].[DepId]  WHERE  ( ";
        $conditions=array();
    
        foreach ($producingLines as $depid=>$wc) {
            if (isset($wc['checked']) && $wc['checked']==1) {
                $conditions[]=" ([dbo].[ProcessWork].[DepId]={$depid} AND [dbo].[ProcessWork].[CenterId]={$wc['CenterId']} )  ";
            }
        }
    
        $sql_tdata.= implode(' OR ', $conditions);
        $sql_tdata.=" ) AND (";
        //制令单未完工、未关闭
        $sql_tdata.=" ([dbo].[ProduceFormM].[Completed]<>3 AND [dbo].[ProduceFormM].[Closed]<>3 AND (([dbo].[ProcessWork].[PStartTime]<='{$endtime}' AND [dbo].[ProcessWork].[Completed]<>3) OR (datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0 ))) ";
        //制令单今日指定完工
        $sql_tdata.=" OR ( datediff(day,[dbo].[ProduceFormM].[FEndTime],GETDATE())=0 AND [dbo].[ProduceFormM].[Completed]=3  AND ((datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  ) OR ([dbo].[ProcessWork].[FEndTime]='1900-01-01'  AND [dbo].[ProcessWork].[PStartTime]<='{$endtime}'))) ";
        //制令单今日指定结束
        $sql_tdata.=" OR ( datediff(day,[dbo].[ProduceFormM].[CloseTime],GETDATE())=0 AND [dbo].[ProduceFormM].[Closed]=3  AND ((datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  ) OR ([dbo].[ProcessWork].[FEndTime]='1900-01-01'  AND [dbo].[ProcessWork].[PStartTime]<='{$endtime}'))) ";
        $sql_tdata.=") AND [dbo].[ProcessWork].[Status]=2  AND [dbo].[ProduceFormM].[Issued]=3  AND  datediff(day,[dbo].[ProcessWork].[PEndTime],GETDATE())=0 ";
      
    } else {

        $t_workcenters=implode(",", $workcenters);
        $sql_tdata="SELECT  sum(ProcessWork.InputNum) ";
        $sql_tdata.=" FROM [dbo].[ProcessWork] INNER JOIN [dbo].[ProduceFormM] ON [dbo].[ProcessWork].[PFormMId] = [dbo].[ProduceFormM].[PFormMId]";
        $sql_tdata.="  LEFT JOIN [dbo].[Department] ON [dbo].[Department].[DepId]=[dbo].[ProcessWork].[DepId] WHERE   ";
        $t_workcenters=implode(",", $workcenters);
        $sql_tdata.="  [dbo].[ProcessWork].[CenterId] IN  ({$t_workcenters}) ";
       
        $sql_tdata.=" AND (";
        //制令单未完工、未关闭
        $sql_tdata.=" ([dbo].[ProduceFormM].[Completed]<>3 AND [dbo].[ProduceFormM].[Closed]<>3 AND (([dbo].[ProcessWork].[PStartTime]<='{$endtime}' AND [dbo].[ProcessWork].[Completed]<>3) OR (datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0 ))) ";
        //制令单今日指定完工
        $sql_tdata.=" OR ( datediff(day,[dbo].[ProduceFormM].[FEndTime],GETDATE())=0 AND [dbo].[ProduceFormM].[Completed]=3  AND ((datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  ) OR ([dbo].[ProcessWork].[FEndTime]='1900-01-01'  AND [dbo].[ProcessWork].[PStartTime]<='{$endtime}'))) ";
        //制令单今日指定结束
        $sql_tdata.=" OR ( datediff(day,[dbo].[ProduceFormM].[CloseTime],GETDATE())=0 AND [dbo].[ProduceFormM].[Closed]=3  AND ((datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  ) OR ([dbo].[ProcessWork].[FEndTime]='1900-01-01'  AND [dbo].[ProcessWork].[PStartTime]<='{$endtime}'))) ";
        $sql_tdata.=" ) AND [dbo].[ProcessWork].[Status]=2  AND [dbo].[ProduceFormM].[Issued]=3 AND  datediff(day,[dbo].[ProcessWork].[PEndTime],GETDATE())=0";

    }
    
    $stmt=sqlsrv_query($conn, $sql_tdata);
    $kpi_today_target=0;
    if ($stmt) {
        $row=sqlsrv_fetch_array($stmt, SQLSRV_FETCH_NUMERIC);
        $kpi_today_target=empty($row[0])?0:$row[0];
        sqlsrv_free_stmt($stmt);
    }
}


//今日产量和合格数
$conditions=array();
$sql1=" SELECT sum(GenuineNum+DefectNum+ScrapNum) as [TNum],sum(GenuineNum) as [TQNum] FROM [dbo].[WorkRecord]  WHERE ";
if ($is_producing_line==1) {

    foreach ($producingLines as $depid=>$wc) {
        if (isset($wc['checked']) && $wc['checked']==1) {
            $conditions[]=" ( [dbo].[WorkRecord].[DepId]={$depid} AND [dbo].[WorkRecord].[CenterId]={$wc['CenterId']} )  ";
        }
    }
    $sql1.= " (".implode(' OR ', $conditions).") ";
} else {
    $t_workcenters=implode(",", $workcenters);
    $sql1.=" [dbo].[WorkRecord].[CenterId] IN  ({$t_workcenters}) ";
}

$sql1.=" AND [dbo].[WorkRecord].[ReportTime]>='{$todaystart}' AND [dbo].[WorkRecord].[ReportTime]<'{$todayend}'  AND [dbo].[WorkRecord].[RecordState]=2";


$stmt=sqlsrv_query($conn, $sql1);
$today_quality_num=0;
$today_total_num=0;
if ($stmt) {
    $row=sqlsrv_fetch_array($stmt, SQLSRV_FETCH_NUMERIC);
    $today_total_num=$row[0];
    $today_quality_num=$row[1];
    sqlsrv_free_stmt($stmt);
}

//今年累计总产量
$conditions=array();
$sql1=" SELECT sum(GenuineNum+DefectNum+ScrapNum) as [TNum],sum(GenuineNum) as [TQNum] FROM [dbo].[WorkRecord]  WHERE ";
if ($is_producing_line==1) {

    foreach ($producingLines as $depid=>$wc) {
        if (isset($wc['checked']) && $wc['checked']==1) {
            $conditions[]=" ( [dbo].[WorkRecord].[DepId]={$depid} AND [dbo].[WorkRecord].[CenterId]={$wc['CenterId']} )  ";
        }
    }
    $sql1.= " (".implode(' OR ', $conditions).") ";
} else {
    $t_workcenters=implode(",", $workcenters);
    $sql1.=" [dbo].[WorkRecord].[CenterId] IN  ({$t_workcenters}) ";
}

$sql1.=" AND [dbo].[WorkRecord].[ReportTime]>='{$fistDayOfThisYear}' AND [dbo].[WorkRecord].[ReportTime]<'{$todayend}'  AND [dbo].[WorkRecord].[RecordState]=2";


$stmt=sqlsrv_query($conn, $sql1);
$all_quality_num=0;
$all_total_num=0;
if ($stmt) {
    $row=sqlsrv_fetch_array($stmt, SQLSRV_FETCH_NUMERIC);
    $all_total_num=$row[0];
    $all_quality_num=$row[1];
    sqlsrv_free_stmt($stmt);
}


//计算总完工率
//'制单号','品号','品名','规格','预开工','实际开工','计划量','完工量','在制量','完工率','效率','状态'
//状态值：下达 完工 超期未开工 超期未完工
$conditions=array();
if ($is_producing_line==1) {
    $sql_tdata="SELECT   sum([dbo].[ProcessWork].[OutputNum]) as TotalOutputNum ,  sum([dbo].[ProcessWork].[InputNum]) as TotalInputNum,count(*) as TotalWoNum ";
    $sql_tdata.="  FROM [dbo].[ProcessWork] INNER JOIN [dbo].[ProduceFormM] ON [dbo].[ProcessWork].[PFormMId] = [dbo].[ProduceFormM].[PFormMId] ";
    $sql_tdata.=" LEFT JOIN [dbo].[Department] ON [dbo].[Department].[DepId]=[dbo].[ProcessWork].[DepId]  WHERE  ( ";


    foreach ($producingLines as $depid=>$wc) {
        if (isset($wc['checked']) && $wc['checked']==1) {
            $conditions[]=" ([dbo].[ProcessWork].[DepId]={$depid} AND [dbo].[ProcessWork].[CenterId]={$wc['CenterId']} )  ";
        }
    }

    $sql_tdata.= implode(' OR ', $conditions);
    $sql_tdata.=" ) AND (";
    //制令单未完工、未关闭
    $sql_tdata.=" ([dbo].[ProduceFormM].[Completed]<>3 AND [dbo].[ProduceFormM].[Closed]<>3 AND (([dbo].[ProcessWork].[PStartTime]<='{$endtime}' AND [dbo].[ProcessWork].[Completed]<>3) OR (datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0 ))) ";
    //制令单今日指定完工
    $sql_tdata.=" OR ( datediff(day,[dbo].[ProduceFormM].[FEndTime],GETDATE())=0 AND [dbo].[ProduceFormM].[Completed]=3  AND ((datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  ) OR ([dbo].[ProcessWork].[FEndTime]='1900-01-01'  AND [dbo].[ProcessWork].[PStartTime]<='{$endtime}'))) ";
    //制令单今日指定结束
    $sql_tdata.=" OR ( datediff(day,[dbo].[ProduceFormM].[CloseTime],GETDATE())=0 AND [dbo].[ProduceFormM].[Closed]=3  AND ((datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  ) OR ([dbo].[ProcessWork].[FEndTime]='1900-01-01'  AND [dbo].[ProcessWork].[PStartTime]<='{$endtime}'))) ";
    $sql_tdata.=") AND [dbo].[ProcessWork].[Status]=2  AND [dbo].[ProduceFormM].[Issued]=3 ";
} else {
    $sql_tdata="SELECT   sum([dbo].[ProcessWork].[OutputNum]) as TotalOutputNum ,  sum([dbo].[ProcessWork].[InputNum]) as TotalInputNum ,count(*) as TotalWoNum";
    $sql_tdata.=" FROM [dbo].[ProcessWork] INNER JOIN [dbo].[ProduceFormM] ON [dbo].[ProcessWork].[PFormMId] = [dbo].[ProduceFormM].[PFormMId]";
    $sql_tdata.="  LEFT JOIN [dbo].[Department] ON [dbo].[Department].[DepId]=[dbo].[ProcessWork].[DepId] WHERE   ";
    $t_workcenters=implode(",", $workcenters);
    $sql_tdata.="  [dbo].[ProcessWork].[CenterId] IN  ({$t_workcenters}) ";

    $sql_tdata.=" AND (";
    //制令单未完工、未关闭
    $sql_tdata.=" ([dbo].[ProduceFormM].[Completed]<>3 AND [dbo].[ProduceFormM].[Closed]<>3 AND (([dbo].[ProcessWork].[PStartTime]<='{$endtime}' AND [dbo].[ProcessWork].[Completed]<>3) OR (datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0 ))) ";
    //制令单今日指定完工
    $sql_tdata.=" OR ( datediff(day,[dbo].[ProduceFormM].[FEndTime],GETDATE())=0 AND [dbo].[ProduceFormM].[Completed]=3  AND ((datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  ) OR ([dbo].[ProcessWork].[FEndTime]='1900-01-01'  AND [dbo].[ProcessWork].[PStartTime]<='{$endtime}'))) ";
    //制令单今日指定结束
    $sql_tdata.=" OR ( datediff(day,[dbo].[ProduceFormM].[CloseTime],GETDATE())=0 AND [dbo].[ProduceFormM].[Closed]=3  AND ((datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  ) OR ([dbo].[ProcessWork].[FEndTime]='1900-01-01'  AND [dbo].[ProcessWork].[PStartTime]<='{$endtime}'))) ";
    $sql_tdata.=") AND [dbo].[ProcessWork].[Status]=2  AND [dbo].[ProduceFormM].[Issued]=3 ";
}

$stmt=sqlsrv_query($conn, $sql_tdata);
$today_output_num=0;
$today_input_num=0;
$wo_num=0;


if ($stmt) {
    $row=sqlsrv_fetch_array($stmt, SQLSRV_FETCH_NUMERIC);
    $today_output_num=$row[0]==null?0:$row[0];
    $today_input_num=$row[1]==null?0:$row[1];
	$wo_num=$row[2]==null?0:$row[2];
    sqlsrv_free_stmt($stmt);
}


//未完工备料
$conditions=array();
if ($is_producing_line==1) {
    $sql_tdata="SELECT   count(*) as UncompletedUnreadiedNum ";
    $sql_tdata.="  FROM [dbo].[ProcessWork] INNER JOIN [dbo].[ProduceFormM] ON [dbo].[ProcessWork].[PFormMId] = [dbo].[ProduceFormM].[PFormMId] ";
    $sql_tdata.=" LEFT JOIN [dbo].[Department] ON [dbo].[Department].[DepId]=[dbo].[ProcessWork].[DepId]  WHERE  ( ";


    foreach ($producingLines as $depid=>$wc) {
        if (isset($wc['checked']) && $wc['checked']==1) {
            $conditions[]=" ([dbo].[ProcessWork].[DepId]={$depid} AND [dbo].[ProcessWork].[CenterId]={$wc['CenterId']} )  ";
        }
    }

    $sql_tdata.= implode(' OR ', $conditions);
    $sql_tdata.=" ) AND (";
    //制令单未完工、未关闭
    $sql_tdata.=" ([dbo].[ProduceFormM].[Completed]<>3 AND [dbo].[ProduceFormM].[Closed]<>3 AND ([dbo].[ProcessWork].[PStartTime]<='{$endtime}' AND [dbo].[ProcessWork].[Completed]<>3)) ";
    $sql_tdata.=") AND [dbo].[ProcessWork].[Status]=2  AND [dbo].[ProduceFormM].[Issued]=3 AND [dbo].[ProduceFormM].[Readied]=0";
} else {
    $sql_tdata="SELECT  count(*) as UncompletedUnreadiedNum";
    $sql_tdata.=" FROM [dbo].[ProcessWork] INNER JOIN [dbo].[ProduceFormM] ON [dbo].[ProcessWork].[PFormMId] = [dbo].[ProduceFormM].[PFormMId]";
    $sql_tdata.="  LEFT JOIN [dbo].[Department] ON [dbo].[Department].[DepId]=[dbo].[ProcessWork].[DepId] WHERE   ";

    $t_workcenters=implode(",", $workcenters);
    $sql_tdata.="  [dbo].[ProcessWork].[CenterId] IN  ({$t_workcenters}) ";
   
    $sql_tdata.=" AND (";
    //制令单未完工、未关闭
    $sql_tdata.=" ([dbo].[ProduceFormM].[Completed]<>3 AND [dbo].[ProduceFormM].[Closed]<>3 AND ([dbo].[ProcessWork].[PStartTime]<='{$endtime}' AND [dbo].[ProcessWork].[Completed]<>3)) ";
    $sql_tdata.=") AND [dbo].[ProcessWork].[Status]=2  AND [dbo].[ProduceFormM].[Issued]=3 AND [dbo].[ProduceFormM].[Readied]=0 ";
}

$uncompleted_unready_num=0;

$stmt=sqlsrv_query($conn, $sql_tdata);
if ($stmt) {
    $row=sqlsrv_fetch_array($stmt, SQLSRV_FETCH_NUMERIC);
    $uncompleted_unready_num=$row[0]==null?0:$row[0];

    sqlsrv_free_stmt($stmt);
}


//今日完工
$conditions=array();
if ($is_producing_line==1) {
    $sql_tdata="SELECT   count(*) as TotalCompletedNum ";
    $sql_tdata.="  FROM [dbo].[ProcessWork] INNER JOIN [dbo].[ProduceFormM] ON [dbo].[ProcessWork].[PFormMId] = [dbo].[ProduceFormM].[PFormMId] ";
    $sql_tdata.=" LEFT JOIN [dbo].[Department] ON [dbo].[Department].[DepId]=[dbo].[ProcessWork].[DepId]  WHERE  ( ";


    foreach ($producingLines as $depid=>$wc) {
        if (isset($wc['checked']) && $wc['checked']==1) {
            $conditions[]=" ([dbo].[ProcessWork].[DepId]={$depid} AND [dbo].[ProcessWork].[CenterId]={$wc['CenterId']} )  ";
        }
    }

    $sql_tdata.= implode(' OR ', $conditions);
    $sql_tdata.=" ) AND (";
    //制令单未完工、未关闭
    $sql_tdata.=" ([dbo].[ProduceFormM].[Completed]<>3 AND [dbo].[ProduceFormM].[Closed]<>3 AND (([dbo].[ProcessWork].[PStartTime]<='{$endtime}' AND [dbo].[ProcessWork].[Completed]<>3) OR (datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0 ))) ";
    //制令单今日指定完工
    $sql_tdata.=" OR ( datediff(day,[dbo].[ProduceFormM].[FEndTime],GETDATE())=0 AND [dbo].[ProduceFormM].[Completed]=3  AND ((datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  ) OR ([dbo].[ProcessWork].[FEndTime]='1900-01-01'  AND [dbo].[ProcessWork].[PStartTime]<='{$endtime}'))) ";
    //制令单今日指定结束
    $sql_tdata.=" OR ( datediff(day,[dbo].[ProduceFormM].[CloseTime],GETDATE())=0 AND [dbo].[ProduceFormM].[Closed]=3  AND ((datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  ) OR ([dbo].[ProcessWork].[FEndTime]='1900-01-01'  AND [dbo].[ProcessWork].[PStartTime]<='{$endtime}'))) ";
    $sql_tdata.=") AND [dbo].[ProcessWork].[Status]=2  AND [dbo].[ProduceFormM].[Issued]=3  AND datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  AND [dbo].[ProcessWork].[Completed]=3";
} else {
    $sql_tdata="SELECT  count(*) as TotalCompletedNum ";
    $sql_tdata.=" FROM [dbo].[ProcessWork] INNER JOIN [dbo].[ProduceFormM] ON [dbo].[ProcessWork].[PFormMId] = [dbo].[ProduceFormM].[PFormMId]";
    $sql_tdata.="  LEFT JOIN [dbo].[Department] ON [dbo].[Department].[DepId]=[dbo].[ProcessWork].[DepId] WHERE   ";
    $t_workcenters=implode(",", $workcenters);
    $sql_tdata.="  [dbo].[ProcessWork].[CenterId] IN  ({$t_workcenters}) ";
   
    $sql_tdata.=" AND (";
    //制令单未完工、未关闭
    $sql_tdata.=" ([dbo].[ProduceFormM].[Completed]<>3 AND [dbo].[ProduceFormM].[Closed]<>3 AND (([dbo].[ProcessWork].[PStartTime]<='{$endtime}' AND [dbo].[ProcessWork].[Completed]<>3) OR (datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0 ))) ";
    //制令单今日指定完工
    $sql_tdata.=" OR ( datediff(day,[dbo].[ProduceFormM].[FEndTime],GETDATE())=0 AND [dbo].[ProduceFormM].[Completed]=3  AND ((datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  ) OR ([dbo].[ProcessWork].[FEndTime]='1900-01-01'  AND [dbo].[ProcessWork].[PStartTime]<='{$endtime}'))) ";
    //制令单今日指定结束
    $sql_tdata.=" OR ( datediff(day,[dbo].[ProduceFormM].[CloseTime],GETDATE())=0 AND [dbo].[ProduceFormM].[Closed]=3  AND ((datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  ) OR ([dbo].[ProcessWork].[FEndTime]='1900-01-01'  AND [dbo].[ProcessWork].[PStartTime]<='{$endtime}'))) ";
    $sql_tdata.=") AND [dbo].[ProcessWork].[Status]=2  AND [dbo].[ProduceFormM].[Issued]=3  AND datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  AND [dbo].[ProcessWork].[Completed]=3";
}

$stmt=sqlsrv_query($conn, $sql_tdata);
$today_completed_num=0;
if ($stmt) {
    $row=sqlsrv_fetch_array($stmt, SQLSRV_FETCH_NUMERIC);
    $today_completed_num=$row[0]==null?0:$row[0];
    sqlsrv_free_stmt($stmt);
}

//开工延期
$conditions=array();
if ($is_producing_line==1) {
    $sql_tdata="SELECT   count(*) as WorkingPostponedNum ";
    $sql_tdata.="  FROM [dbo].[ProcessWork] INNER JOIN [dbo].[ProduceFormM] ON [dbo].[ProcessWork].[PFormMId] = [dbo].[ProduceFormM].[PFormMId] ";
    $sql_tdata.=" LEFT JOIN [dbo].[Department] ON [dbo].[Department].[DepId]=[dbo].[ProcessWork].[DepId]  WHERE  ( ";


    foreach ($producingLines as $depid=>$wc) {
        if (isset($wc['checked']) && $wc['checked']==1) {
            $conditions[]=" ([dbo].[ProcessWork].[DepId]={$depid} AND [dbo].[ProcessWork].[CenterId]={$wc['CenterId']} )  ";
        }
    }

    $sql_tdata.= implode(' OR ', $conditions);
    $sql_tdata.=" ) AND (";
    //制令单未完工、未关闭
    $sql_tdata.=" ([dbo].[ProduceFormM].[Completed]<>3 AND [dbo].[ProduceFormM].[Closed]<>3 AND (([dbo].[ProcessWork].[PStartTime]<='{$endtime}' AND [dbo].[ProcessWork].[Completed]<>3) OR (datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0 ))) ";
    $sql_tdata.=") AND [dbo].[ProcessWork].[Status]=2  AND [dbo].[ProduceFormM].[Issued]=3   AND (( datediff(second,[dbo].[ProcessWork].[PStartTime],GETDATE())>0  AND ([dbo].[ProcessWork].[FStartTime]='1900-01-01' or  [ProcessWork].[FStartTime] is null)  ) or (  [dbo].[ProcessWork].[FStartTime] is not null and  [dbo].[ProcessWork].[FStartTime]<>'1900-01-01' and datediff(second,[dbo].[ProcessWork].[PStartTime],[dbo].[ProcessWork].[FStartTime])>0 ) ) ";
} else {
    $sql_tdata="SELECT  count(*) as WorkingPostponedNum ";
    $sql_tdata.=" FROM [dbo].[ProcessWork] INNER JOIN [dbo].[ProduceFormM] ON [dbo].[ProcessWork].[PFormMId] = [dbo].[ProduceFormM].[PFormMId]";
    $sql_tdata.="  LEFT JOIN [dbo].[Department] ON [dbo].[Department].[DepId]=[dbo].[ProcessWork].[DepId] WHERE   ";
    $t_workcenters=implode(",", $workcenters);
    $sql_tdata.="  [dbo].[ProcessWork].[CenterId] IN  ({$t_workcenters}) ";
   
    $sql_tdata.=" AND (";
    //制令单未完工、未关闭
    $sql_tdata.=" ([dbo].[ProduceFormM].[Completed]<>3 AND [dbo].[ProduceFormM].[Closed]<>3 AND (([dbo].[ProcessWork].[PStartTime]<='{$endtime}' AND [dbo].[ProcessWork].[Completed]<>3) )) ";

    $sql_tdata.=") AND [dbo].[ProcessWork].[Status]=2  AND [dbo].[ProduceFormM].[Issued]=3    AND (( datediff(second,[dbo].[ProcessWork].[PStartTime],GETDATE())>0  AND ([dbo].[ProcessWork].[FStartTime]='1900-01-01' or  [ProcessWork].[FStartTime] is null)  ) or (  [dbo].[ProcessWork].[FStartTime] is not null and  [dbo].[ProcessWork].[FStartTime]<>'1900-01-01' and datediff(second,[dbo].[ProcessWork].[PStartTime],[dbo].[ProcessWork].[FStartTime])>0 ) ) ";
}

$stmt=sqlsrv_query($conn, $sql_tdata);
$working_postponed_num=0;
if ($stmt) {
    $row=sqlsrv_fetch_array($stmt, SQLSRV_FETCH_NUMERIC);
    $working_postponed_num=$row[0]==null?0:$row[0];
    sqlsrv_free_stmt($stmt);
}

//超期未完工
$conditions=array();
if ($is_producing_line==1) {
    $sql_tdata="SELECT   count(*)  ";
    $sql_tdata.="  FROM [dbo].[ProcessWork] INNER JOIN [dbo].[ProduceFormM] ON [dbo].[ProcessWork].[PFormMId] = [dbo].[ProduceFormM].[PFormMId] ";
    $sql_tdata.=" LEFT JOIN [dbo].[Department] ON [dbo].[Department].[DepId]=[dbo].[ProcessWork].[DepId]  WHERE  ( ";


    foreach ($producingLines as $depid=>$wc) {
        if (isset($wc['checked']) && $wc['checked']==1) {
            $conditions[]=" ([dbo].[ProcessWork].[DepId]={$depid} AND [dbo].[ProcessWork].[CenterId]={$wc['CenterId']} )  ";
        }
    }

    $sql_tdata.= implode(' OR ', $conditions);
    $sql_tdata.=" ) AND (";
    //制令单未完工、未关闭
    $sql_tdata.=" ([dbo].[ProduceFormM].[Completed]<>3 AND [dbo].[ProduceFormM].[Closed]<>3 AND (([dbo].[ProcessWork].[PStartTime]<='{$endtime}' AND [dbo].[ProcessWork].[Completed]<>3) OR (datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0 ))) ";
    //制令单今日指定完工
    $sql_tdata.=" OR ( datediff(day,[dbo].[ProduceFormM].[FEndTime],GETDATE())=0 AND [dbo].[ProduceFormM].[Completed]=3  AND ((datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  ) OR ([dbo].[ProcessWork].[FEndTime]='1900-01-01'  AND [dbo].[ProcessWork].[PStartTime]<='{$endtime}'))) ";
    //制令单今日指定结束
    $sql_tdata.=" OR ( datediff(day,[dbo].[ProduceFormM].[CloseTime],GETDATE())=0 AND [dbo].[ProduceFormM].[Closed]=3  AND ((datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  ) OR ([dbo].[ProcessWork].[FEndTime]='1900-01-01'  AND [dbo].[ProcessWork].[PStartTime]<='{$endtime}'))) ";
    $sql_tdata.=") AND [dbo].[ProcessWork].[Status]=2  AND [dbo].[ProduceFormM].[Issued]=3     AND datediff(second,[dbo].[ProcessWork].[PEndTime],GETDATE())>0  AND [dbo].[ProcessWork].[FEndTime]='1900-01-01'  ";
} else {
    $sql_tdata="SELECT  count(*) as WorkingPostponedNum ";
    $sql_tdata.=" FROM [dbo].[ProcessWork] INNER JOIN [dbo].[ProduceFormM] ON [dbo].[ProcessWork].[PFormMId] = [dbo].[ProduceFormM].[PFormMId]";
    $sql_tdata.="  LEFT JOIN [dbo].[Department] ON [dbo].[Department].[DepId]=[dbo].[ProcessWork].[DepId] WHERE   ";
    $t_workcenters=implode(",", $workcenters);
    $sql_tdata.="  [dbo].[ProcessWork].[CenterId] IN  ({$t_workcenters}) ";
   
    $sql_tdata.=" AND (";
    //制令单未完工、未关闭
    $sql_tdata.=" ([dbo].[ProduceFormM].[Completed]<>3 AND [dbo].[ProduceFormM].[Closed]<>3 AND (([dbo].[ProcessWork].[PStartTime]<='{$endtime}' AND [dbo].[ProcessWork].[Completed]<>3) OR (datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0 ))) ";
    //制令单今日指定完工
    $sql_tdata.=" OR ( datediff(day,[dbo].[ProduceFormM].[FEndTime],GETDATE())=0 AND [dbo].[ProduceFormM].[Completed]=3  AND ((datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  ) OR ([dbo].[ProcessWork].[FEndTime]='1900-01-01'  AND [dbo].[ProcessWork].[PStartTime]<='{$endtime}'))) ";
    //制令单今日指定结束
    $sql_tdata.=" OR ( datediff(day,[dbo].[ProduceFormM].[CloseTime],GETDATE())=0 AND [dbo].[ProduceFormM].[Closed]=3  AND ((datediff(day,[dbo].[ProcessWork].[FEndTime],GETDATE())=0  ) OR ([dbo].[ProcessWork].[FEndTime]='1900-01-01'  AND [dbo].[ProcessWork].[PStartTime]<='{$endtime}'))) ";
    $sql_tdata.=") AND [dbo].[ProcessWork].[Status]=2  AND [dbo].[ProduceFormM].[Issued]=3    AND datediff(second,[dbo].[ProcessWork].[PEndTime],GETDATE())>0  AND [dbo].[ProcessWork].[FEndTime]='1900-01-01'  ";
}

$stmt=sqlsrv_query($conn, $sql_tdata);
$exceeded_uncompleted_num=0;
if ($stmt) {
    $row=sqlsrv_fetch_array($stmt, SQLSRV_FETCH_NUMERIC);
    $exceeded_uncompleted_num=$row[0]==null?0:$row[0];
    sqlsrv_free_stmt($stmt);
}






$response['code']=200;
$response['kpi_today_target']=round($kpi_today_target?$kpi_today_target:0, 0);
$response['today_quality_num']=round($today_quality_num?$today_quality_num:0, 0);
$response['today_total_num']=round($today_total_num?$today_total_num:0, 0);
$response['all_quality_num']=round($all_quality_num?$all_quality_num:0, 0)+$initOutput;
$response['all_total_num']=round($all_total_num?$all_total_num:0, 0);
$response['wo_num']=round($wo_num?$wo_num:0, 0);
$response['uncompleted_unready_num']=round($uncompleted_unready_num?$uncompleted_unready_num:0, 0);
$response['today_completed_num']=round($today_completed_num?$today_completed_num:0, 0);
$response['working_postponed_num']=round($working_postponed_num?$working_postponed_num:0, 0);
$response['exceeded_uncompleted_num']=round($exceeded_uncompleted_num?$exceeded_uncompleted_num:0, 0);
// header('Content-Type:application/json;charset=utf-8;');
echo json_encode($response);
