<?php
	include_once ('../../define.php');	
	include_once('../../config.php');
	include_once('../../dbcon.php');
	date_default_timezone_set("PRC");
	

?>

function toggleFullScreen() {
	  if (!document.fullscreenElement) {
		  document.documentElement.requestFullscreen();
	  } else {
		if (document.exitFullscreen) {
		  document.exitFullscreen(); 
		}
	  }
}

layui.use(['table','jquery'],function(){
	var $=layui.jquery;
	var table=layui.table;
	var col=0;

	var setTime=function(){		
		var datetime=new Date();
		var timestring=datetime.getFullYear()+'.'+formatNumber(datetime.getMonth()+1).toString()+'.'+formatNumber(datetime.getDate())+' ';
			timestring+=formatNumber(datetime.getHours())+':'+formatNumber(datetime.getMinutes());
		$('#clock h1').html(timestring);
	}
	setTime();
	var clockInterval=setInterval(setTime,1000*60);
	var height=$('#datafield').height();
	var wsHeight=$('body').height()-100-500-80;
	$('#workshop-sections').height(wsHeight);


	document.addEventListener("keydown", function(e) {
	  if (e.keyCode == 13) { 
		toggleFullScreen();		
	  }
	}, false);
	document.addEventListener('fullscreenchange',function(evt){
		var wsHeight=$('body').height()-100-500-80;
		//alert(wsHeight);
		$('#workshop-sections').height(wsHeight);			
	});
	
	//需要修改调优
	//$('#totalPlans').height((height-15)/2);
	//$('#totalExecutions').height((height-15)/2);
	var tableChangePage=new Array();
	var messageChange=new Array();
	var workshops=[<?php echo implode(',',$config['work_order']['workshop_session']); ?>];
	var curworkshopix=0;
	getData(workshops[curworkshopix],{height:height},0,workshops);
	var workshop_data_interval=setInterval(function(){
		curworkshopix+=1;
		if(curworkshopix>workshops.length-1){
			curworkshopix=0;
		}
		var workshopid=workshops[curworkshopix];
		getData(workshopid,{height:height},curworkshopix,workshops);
		//$('#workshop-sections').scrollLeft(250*(curworkshopix+1));
		var wss=$('#workshop-sections').width();
		var cix=Math.ceil((wss/255)/2);
		if((curworkshopix+1)>cix){
			$('#workshop-sections').scrollLeft((curworkshopix+1-cix)*255);
		}else{
			$('#workshop-sections').scrollLeft(0);
		}			
		
	},1000*60*<?php echo $config['parameters']['interval']; ?> );

	function getData(workshopid,params,ix,workshops){
		var lastworkshopix=ix-1;
		if(lastworkshopix<0){
			lastworkshopix=workshops.length-1;
		}
		if(tableChangePage[lastworkshopix]!=null){
			clearInterval(tableChangePage[lastworkshopix]);
		}
		
		if(messageChange[lastworkshopix]!=null){
			clearInterval(messageChange[lastworkshopix]);
		}	
		
		$.get("module/getData.php?workshopid="+workshopid,function(data){
			
			for(var workshopix in data.workshops){
				var workshop=data.workshops[workshopix];
				//更新达成率
				if(workshop['achieving_rate'] !='*' && workshop['achieving_rate']<data.achieving_rate_warning_line){
					$('[data-centerid="'+workshop['CenterId']+'"] .achieving_rate').html('<span style="color:red">'+Math.round(workshop['achieving_rate']*10000)/100+'%</span>');	
				}else{
					if(workshop['achieving_rate'] !='*'){
						$('[data-centerid="'+workshop['CenterId']+'"] .achieving_rate').html(Math.round(workshop['achieving_rate']*10000)/100+'%');	
					}else{
						$('[data-centerid="'+workshop['CenterId']+'"] .achieving_rate').html(workshop['achieving_rate']);	
					}
												
				}
		
				//更新良率
				if(workshop['qualified_rate']!='*'){
					$('[data-centerid="'+workshop['CenterId']+'"] .qualified_rate').html(Math.round(workshop['qualified_rate']*100)/100+'%');	
				}else{
					$('[data-centerid="'+workshop['CenterId']+'"] .qualified_rate').html(workshop['qualified_rate']);					
				}
	
				//判断是否需要预警
				//console.log($(workshop['achieving_rate']).text(),data.achieving_rate_warning_line,workshop['achieving_rate']<data.achieving_rate_warning_line)
				if(workshop['achieving_rate']<data.achieving_rate_warning_line){
					//console.log(workshop['CenterId'],111);
					//预警
					$('[data-centerid="'+workshop['CenterId']+'"] .warning_icon').html('<img src="static/image/warning.png" />');
				}else{
					$('[data-centerid="'+workshop['CenterId']+'"] .warning_icon').html('<img src="static/image/nowarning.png" />');			
				}
				if(workshop['CenterId']==workshopid){
					
					$('[data-centerid="'+workshop['CenterId']+'"]').addClass('active');
					$('#cur-workshop-name').html(workshop['CenterName']);
					
					
				}else{
					
					$('[data-centerid="'+workshop['CenterId']+'"]').removeClass('active');					
				}
			}
			
			$('#making-order-num').html(Math.round(data.order_num*100)/100);
			$('#making-num').html(Math.round(data.pro_sum_num*100)/100);
			//$('#total-finished-rate').html(data.total_finished_rate);
			$('#qualified-num').html(Math.round(data.total_unq*100)/100);
			$('#finished-num').html(Math.round(data.total_com*100)/100);
			//$('#total-qualified-rate').html(data.total_qualified_rate);
			var canvas1=document.getElementById('canvas1');	
			var context1=canvas1.getContext("2d");
			context1.clearRect(0,0,canvas1.width,canvas1.height); 
			context1.fillStyle="#7d77aa";
			context1.font="20px 黑体";
			context1.fillText(Math.round(data.total_finished_rate*100*100)/100+'%',20,50);
			context1.fillStyle="#bfbfbf";
			context1.fillRect(20,60,30,(1-data.total_finished_rate)*120);
			context1.fillStyle="#00b050";
			context1.fillRect(20,(1-data.total_finished_rate)*120+60,30,data.total_finished_rate*120);
			context1.fillStyle="#000";
			context1.font="20px 黑体";
			context1.fillText("进度",17,210);
			var canvas2=document.getElementById('canvas2');
			var context2=canvas2.getContext("2d");
			context2.clearRect(0,0,canvas2.width,canvas2.height); 
			context2.fillStyle="#7d77aa";
			context2.font="20px 黑体";
			context2.fillText(Math.round(data.total_qualified_rate*100*100)/100+'%',20,50);
			context2.fillStyle="yellow";
			context2.fillRect(20,60,30,(1-data.total_qualified_rate)*120);
			context2.fillStyle="#00b050";
			context2.fillRect(20,(1-data.total_qualified_rate)*120+60,30,data.total_qualified_rate*120);
			context2.fillStyle="#000";
			context2.font="20px 黑体";			
			context2.fillText("良率",17,210);			
			var col=0;
			var count=data.count;
			var totalpage=data.totalpage;
			var curpage=1;
			var table_params={
				elem: '#datatable'
				,height: params.height
				,page: {
					count:data.count,
					curr:curpage,
					limit:6,
					limits:[6]
				} //开启分页
				,data:data.tdata
				//,data:[{col0:'<span style="color:red">1</span>'},{col0:1},{col0:1},{col0:1},{col0:1},{col0:1},{col0:1},{col0:1},{col0:1},{col0:1},{col0:1}]
				,cols: [[ //表头
					<?php foreach($config['parameters']['cols'] as $k => $v ):?>
						{field: 'col'+(col++).toString(), title: '<?php echo $k; ?>',
						width:'<?php echo empty($config['parameters']['colwidths'][$k])?'80':$config['parameters']['colwidths'][$k] ; ?>'
						, hide:<?php echo $v==true?'false':'true'; ?>
						},
					<?php endforeach;?>
				]]

			};
			table.render(table_params);
			
			(function(curworkshopid,cix){
				var curpage=1;
				var messages=data.messages;
				var curmix=-1;
				
				//console.log("cur:"+curworkshopid.toString());
				//console.log("curix:"+cix.toString());
				tableChangePage[cix]=setInterval(function(){
					if(curworkshopid==workshopid){
						curpage+=1;
						if(curpage>totalpage){
							curpage=1;
						}
					
							table_params.page.curr=curpage;
							//console.log(table_params);
							table.render(table_params);	
									
					}else{
						clearInterval(tableChangePage[cix]);
						console.log('not equal cur:'+curworkshopid.toString()+'real :'+workshopid.toString());
					}
				
				},10*1000);
				
				var msg="消息通知：";
				for(var i=0;i<messages.length;i++){
					msg+=(i+1).toString()+"、"+(messages[i].MessageContent?messages[i].MessageContent:"")+" ";
				}
				msg='<div  style="position:absolute;height:100%;white-space: nowrap;line-height:80px;" id="msg2" >'+msg+'</div>';
				$("#message").html(msg);
				var messagelength=$('#msg2').width();
				var messageContainerLength=$('#message').width();
				var left=messageContainerLength;
				$("#msg2").css({left:left.toString()+'px'});
				messageChange[cix]=setInterval(function(){	
					left-=20;
					//console.log(-messagelength);
					//console.log(left);
					if(left<-messagelength){
						left=messageContainerLength;
					}
					//console.log(left);
					$("#msg2").css({left:left.toString()+'px'});			
				},500);				
				/*
				if((curmix+3) <= messages.length-1){
					for(i=curmix+1;i<=curmix+3;i++){
						msg+=(i%3+1).toString()+"、"+(messages[i].MessageContent?messages[i].MessageContent:"")+" ";
					}
					
					curmix=curmix+3;
					
				}else{
					
					for(i=curmix+1;i<=messages.length-1;i++){
						msg+=(i%3+1).toString()+"、"+(messages[i].MessageContent?messages[i].MessageContent:"")+" ";
					}
					
					curmix=0;
				}
					
					
					$("#message").html(msg)				
				messageChange[cix]=setInterval(function(){
					
					var msg="消息通知：";
					if((curmix+3) < messages.length-1){
						for(i=curmix+1;i<=curmix+3;i++){
							msg+=(i%3+1).toString()+"、"+(messages[i].MessageContent?messages[i].MessageContent:"")+" ";
						}
						
						curmix=curmix+3;
						
					}else{
						
						for(i=curmix+1;i<=messages.length-1;i++){
							msg+=(i%3+1).toString()+"、"+(messages[i].MessageContent?messages[i].MessageContent:"")+" ";
						}
						
						curmix=0;
					}
					
					$("#message").html(msg)
					
					
				},10*1000); */

				
			})(workshopid,ix);

		},'json');
					
	}
	
	function formatNumber(n) {
			n = n.toString()
			return n[1] ? n : '0' + n
	}

})





