<?php


class Rsa {
 
    /**     
     * 获取私钥     
     * @return bool|resource     
     */    
    private static function getPrivateKey() 
    {        
        //$abs_path = dirname(__FILE__) . '/rsa_private_key.pem';
        //$content = file_get_contents($abs_path); 
		$content="
-----BEGIN RSA PRIVATE KEY-----
MIICXAIBAAKBgQCH6kiMwa+blOovBM7RhyzYDyA+s66sGqn9riQUFA0s6sdsTheg
dAreRGq1bzta4uSK9bEsgdKhEkQ0LNkf7xS2OJi7c3cHYicaRQoyBHDreVXPEIq2
B712fmpjUBCgaUYELjOgotzErI5xAYsqWVDA6I4tUmIln0duZ/69fqXV9wIDAQAB
AoGATOUZwrjZ93XawFtB/30wu9Ri89aInko/noxlUQ6/HYh+5yGPcHH2rCWdEaUq
uZLgplW2tW2FkydYewRcmxqSZmpJZboJilZnmO+/q+tngS9pHphm0GktRZuji5l4
W7poGT9gZgCDl8hDj15TIlHmy+LZb4tbg7rvhGcAWxA1nKECQQDGfE6KocSo7Nim
I+ZgMI7LHM/hnPpXJJHwHgBkio4N745N+j30iPSoBAbIfKw0r4YWTXzSt7gxLOhb
H9L7rMR/AkEAr0x+VwuqGJdRYYeHSbKgDAl7HrUcnQTGZCx+Vk6Q76UI1Px+Rz9/
dWdpj5QhEKsh0O6GWVbV8ftuUsPrZ8BSiQJBAMR0EMECMEYKdryqV8DpDsxWbiMe
XmGWHqQM7dKVmNiOPMlNX7kDPTR3F8ekLkXPXOYCOAPQN4zkp+5ZZ1gWvj0CQAUc
juaM4YXcC7RzVj+Q5NfVAvEPSOlPNVXAcmKj4dgLEOnc/vWm5VmQDWTxZdFtnAvS
mLpMLOrkcQAa1GdvFTkCQFb37JfRSWm//Bzn3+SJyFMRTZ2LsiA0v577gTxnCXd8
CGAk2783sQEnUZQgwRfrvybkJChN6dnAVhS6Yiuydz4=
-----END RSA PRIVATE KEY-----
";
		$content=trim($content);
        return openssl_pkey_get_private($content);    
    }    

    /**     
     * 获取公钥     
     * @return bool|resource     
     */    
    private static function getPublicKey()
    {   
       // $abs_path = dirname(__FILE__) . '/rsa_public_key.pem';
       // $content = file_get_contents($abs_path);

		$content="
-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCH6kiMwa+blOovBM7RhyzYDyA+
s66sGqn9riQUFA0s6sdsThegdAreRGq1bzta4uSK9bEsgdKhEkQ0LNkf7xS2OJi7
c3cHYicaRQoyBHDreVXPEIq2B712fmpjUBCgaUYELjOgotzErI5xAYsqWVDA6I4t
UmIln0duZ/69fqXV9wIDAQAB
-----END PUBLIC KEY-----";
		$content=trim($content);
        return openssl_pkey_get_public($content);     
    }

    /**     
     * 私钥加密     
     * @param string $data     
     * @return null|string     
     */    
    public static function privEncrypt($data = '')    
    {        
        if (!is_string($data)) {            
            return null;       
        }        
        return openssl_private_encrypt($data,$encrypted,self::getPrivateKey()) ? base64_encode($encrypted) : null;    
    }    

    /**     
     * 公钥加密     
     * @param string $data     
     * @return null|string     
     */    
    public static function publicEncrypt($data = '')   
    {        
        if (!is_string($data)) {            
            return null;        
        }        
        return openssl_public_encrypt($data,$encrypted,self::getPublicKey()) ? base64_encode($encrypted) : null;    
    }    

    /**     
     * 私钥解密     
     * @param string $encrypted     
     * @return null     
     */    
    public static function privDecrypt($encrypted = '')    
    {        
        if (!is_string($encrypted)) {            
            return null;        
        }        
        return (openssl_private_decrypt(base64_decode($encrypted), $decrypted, self::getPrivateKey())) ? $decrypted : null;    
    }    

    /**     
     * 公钥解密     
     * @param string $encrypted     
     * @return null     
     */    
    public static function publicDecrypt($encrypted = '')    
    {        
        if (!is_string($encrypted)) {            
            return null;        
        }        
    return (openssl_public_decrypt(base64_decode($encrypted), $decrypted, self::getPublicKey())) ? $decrypted : null;    
    }

}