<?php
include_once('./rsa.php');

session_start();
$sid=session_id();
$fid=isset($_COOKIE['fid'])?$_COOKIE['fid']:'';
$fid=Rsa::publicDecrypt($fid);
$guid=isset($_COOKIE['guid'])?$_COOKIE['guid']:'';
$guid=Rsa::publicDecrypt($guid);



//授权文件不存在，跳转
if(!file_exists('/auth/certs/'.$fid.'.key')){
	echo '授权失败，正在跳转';
	echo '<script>setTimeout(function(){window.location=\'auth.php\';},1500);</script>';
	die();			
}

if(!file_exists('/auth/tmp/'.$guid)){

	echo '该客户端未授权,请授权后访问';
	echo '<script>setTimeout(function(){window.location=\'auth.php\';},1500);</script>';
	die();

}else{

	$lines=file_get_contents('/auth/tmp/'.$guid);
	$lines=explode("\n",$lines);
	$flag=false;

	foreach($lines as $line){
		
		if($line!=""){
			$d=Rsa::privDecrypt(trim($line));
			if(empty($d)){ continue;}
			$d=explode('::',trim($d));
			//相等表明之前授权过，并且没有被踢掉
			if($d[1]==$sid){
				$flag=true;
				break;
			}
		}
		
	}

	if($flag==false){
		echo '该客户端未授权,请授权后访问';
		echo '<script>setTimeout(function(){window.location=\'auth.php\';},1500);</script>';
		die();
	}
}

date_default_timezone_set("PRC");
require_once('common/base.php');	
?>
<!doctype html>
<html>
<head>
	<meta http-equiv="refresh" content="10800" />
    <script src="static/js/vue.min.js" ></script>
    <script src="static/js/axios.min.js" ></script>   
    <script src="static/js/echarts.min.js" ></script> 
    <link rel="stylesheet" href="static/css/base.css">
    <!-- 引入样式 -->
    <link rel="stylesheet" href="static/element-ui/index.css">
    <!-- 引入组件库 -->
    <script src="static/element-ui/index.js"></script>    
    <style>

        html,body{
            height:1080px;
            width:1920px;
            padding:0px;
            margin:0px;
            box-sizing:border-box;

        }

        body{
            background:url(static/image/bg.jpg);
			background-repeat:no-repeat;background-size:100% 100%;
            
        }

        div{
            box-sizing:border-box;
        }

        #app{
            height:100%;
            width:100%;
            color:#efefef;
            overflow:hidden;
            
        }

        .header{
            height:100px;
            display:flex;
            justify-content:center;
            align-items:center;
            position:relative;
          
        }

        .body{    
            height:calc(100% - 100px);
            width:100%;

        }


        .row{
            display:flex;
            justify-content:center;
            align-items:center;
            background:transparent;
        }

        .row1{
            height:26%;
        }

        .row2{
            height:30%;

        }

        .row3{
            height:44%;
        }

        .caption{
            width:100%;
            height:35px;
            display:flex;
            justify-content:space-between;
            font-size:20px;
            color:#a7c6e5;
        }

        .content{
            width:100%;
            height:calc(100% - 35px);
            padding-bottom:10px;
        }
        .el-table{
            background:rgba(0,0,0,0);
            color:#fcfdfd;
        }
        .el-table thead tr,.el-table thead th{
            background:rgba(0,0,0,0);
            color:#fcfdfd;
            padding:5px 0;
            font-size:15px;
            
        }
        .el-table__header-wrapper{

            border-bottom:solid 2px #a7c6e5;
        }
        .el-table--border, .el-table--group {
            border-top:solid 1px #a7c6e5 ;
            border-bottom:solid 0px #a7c6e5 !important;
        }
        .el-table__header-wrapper thead{
            display:table-row-group;
        }

        .el-table  tr{
            background:rgba(0,0,0,0); 
        }
        .el-table  tr td div.cell{
            overflow:hidden;
            white-space:nowrap;
            font-size:15px;
        }
        .el-table--striped .el-table__body tr.el-table__row--striped td,.el-table--enable-row-hover .el-table__body tr:hover>td{
            background:rgba(0,0,0,0.05)
        }
        .w-content .el-table__header-wrapper{
            height:14% !important;

        }
        .w-content .el-table__header-wrapper .el-table__header{
            height:100%;
        }       
        .w-content .el-table__body-wrapper{
            height:86% !important;
        }
        .w-content .el-table__body-wrapper::-webkit-scrollbar{
            /* height:3px;
            background:red; */
        } 
        .w-content .el-table__body-wrapper .el-table__body{
            height:100% !important;
        }
        .w-content .el-table__body-wrapper .el-table__body tr{
            height:16.667%;
        }
        .m-content .el-table__header-wrapper{

            height:14% !important;           
        }
        .m-content .el-table__header-wrapper .el-table__header{

            height:100% !important;
     
        }
        .m-content .el-table__body-wrapper{
            height:86% !important;

        }

        .m-content .el-table__body-wrapper .el-table__body{
            height:100% !important;
        }  
        .m-content .el-table__body-wrapper .el-table__body tr{
            height:16.667%;
        }

        .el-table th.is-leaf{
             border-bottom:solid 0px;
         } 
         .el-table--border td, .el-table--border th, .el-table__body-wrapper .el-table--border.is-scrolling-left~.el-table__fixed{
            border-right:solid 1px #a7c6e5;
         }
         .el-table td{
            border-bottom:solid 1px #a7c6e5;
            color:#fcfdfd;            
         }

         .up{
             font-size:26px;
         }
         .down{
             margin-top:20px;
             font-size:29px;
         }
		 
		 @media screen and (max-height:1000px){
			 .up{
				 /* font-size:26px; */
			 }
			 .down{
				 /* margin-top:3px;
				 font-size:14.5px; */
			 }			

			.down .cell{
				/* height:24px;
				width:17.5px; */
			}
			 
		 }
    </style>
</head>

<body>

    <div id="app" >
        <div class="header" >
            <img src="static/image/logo.png" style="position:absolute;top:5px;left:20px;height:100px;" />
            <!-- <div style="border:solid 35px;width:0px;height:0px;border-color:#5d96cf #5d96cf rgba(0,0,0,0) rgba(0,0,0,0);"></div> -->
            <div class="title" style="height:100%;width:800px;display:flex;flex-direction:column;justify-content:center;align-items:center;color:white;font-size:28px;">
                <div class="main-title" style="font-size:26px;"><?php echo $config['parameters']['ekb_name'] ;?></div>
                <div class="sub-title" style="font-size:14px;"><?php echo $config['parameters']['sub_ekb_name'] ;?> </div>
            </div>
            <!-- <div style="border:solid 35px;width:0px;height:0px;border-color:#5d96cf  rgba(0,0,0,0) rgba(0,0,0,0) #5d96cf;"></div> -->
            <div class="date hflex hflex-c" style="position:absolute;top:5px;right:20px;height:60px;">
                <div>{{time}}</div>
            </div>
        </div>
        <div class="body  padlf10" >
            <div class="row row1 padtb15" style="padding-top:20px;">
                <div class="col14 vflex vflex-vc h100p" style="flex-wrap:wrap">
                    <div class=" hflex hflex-hstart  h50p">
                        <div class="col20-6 vflex vflex-hc summary-cell">
                            <div class="up">
                                累计产量
                            </div>
                            <div class="down hflex">
                                <div class="cell hflex hflex-c" v-for="(v,i) in all_quality_num" style="background:#6ba5df;height:60px;width:35px;margin-right:2px;font-size:35px;">
                                    {{v}}
                                </div>
                            </div>
                        </div>
                        <div class="col20-3 vflex vflex-hc summary-cell">
                            <div class="up">
                                今日目标
                            </div>
                            <div class="down hflex">
                                <div class="cell hflex hflex-c" v-for="(v,i) in today_target" style="background:#6ba5df;height:60px;width:35px;margin-right:2px;font-size:35px;">
                                    {{v}}
                                </div>
                            </div>
                        </div>
                        <div class="col20-3 vflex  vflex-hc  summary-cell">
                            <div class="up">
                                当前产量
                            </div>
                            <div class="down hflex">
                                <div class="cell hflex hflex-c" v-for="(v,i) in today_total_num" style="background:#6ba5df;height:60px;width:35px;margin-right:2px;font-size:35px;">
                                        {{v}}
                                </div>
                            </div>
                        </div>
                        <div class="col20-3 vflex  vflex-hc  summary-cell">
                            <div class="up">
                                合格数
                            </div>
                            <div class="down hflex ">
                                <div class="cell hflex hflex-c" v-for="(v,i) in today_quality_num" style="background:#6ba5df;height:60px;width:35px;margin-right:2px;font-size:35px;">
                                        {{v}}
                                </div>
                            </div>
                        </div>
                        <div class="col20-3 vflex  vflex-hc  summary-cell">
                            <div class="up">
                                工单张数
                            </div>
                            <div class="down hflex">
                                <div class="cell hflex hflex-c" v-for="(v,i) in wo_num" style="background:#6ba5df;height:60px;width:35px;margin-right:2px;font-size:35px;">
                                        {{v}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class=" vflex vflex-vc vflex-hc  h50p" v-if="<?php echo (!isset($config['parameters']['work_order_data_show']) || $config['parameters']['work_order_data_show']==0 )?'false':'true'; ?>" >
                        <div class="col20-19 hflex hflex-vc h100p padlf20" style="margin-top:25px;height:70%;font-size:24px;color:yellow;background:linear-gradient(#3f87c2,#3e86c1)">当前生产工单中，今日完工{{today_completed_num}}张，在制未完成备料{{uncompleted_unready_num}}张，开工延期{{working_postponed_num}}张，超期未完工{{exceeded_uncompleted_num}}张</div>
                    </div>

                    <!-- <div class="col6 vflex  vflex-hc  summary-cell">
                        <div class="up">
                            未完成备料
                        </div>
                        <div class="down hflex">
                            <div class="cell hflex hflex-c" v-for="(v,i) in uncompleted_unready_num" style="background:#6ba5df;height:60px;width:35px;margin-right:2px;font-size:35px;">
                                    {{v}}
                            </div>
                        </div>
                    </div>
                    <div class="col6 vflex  vflex-hc  summary-cell">
                        <div class="up">
                            今日完工
                        </div>
                        <div class="down hflex">
                            <div class="cell hflex hflex-c" v-for="(v,i) in today_completed_num" style="background:#6ba5df;height:60px;width:35px;margin-right:2px;font-size:35px;">
                                    {{v}}
                            </div>
                        </div>
                    </div> -->
                    <!-- <div class="col6 vflex  vflex-hc  summary-cell">
                        <div class="up">
                            开工延期
                        </div>
                        <div class="down hflex">
                            <div class="cell hflex hflex-c" v-for="(v,i) in working_postponed_num" style="background:#6ba5df;height:60px;width:35px;margin-right:2px;font-size:35px;">
                                    {{v}}
                            </div>
                        </div>
                    </div>
                    <div class="col6 vflex  vflex-hc  summary-cell">
                        <div class="up">
                            超期未完工
                        </div>
                        <div class="down hflex">
                            <div class="cell hflex hflex-c" v-for="(v,i) in exceeded_uncompleted_num" style="background:#6ba5df;height:60px;width:35px;margin-right:2px;font-size:35px;">
                                    {{v}}
                            </div>
                        </div>
                    </div>					 -->
                </div>
                <div class="col10 h100p">
                    <div class="w100p h100px" ref="chart3" style="height:100%;background-repeat:no-repeat;background-size:100% 100%">
                    
                    </div>
                </div>
            </div>
            <div class="row row2">
                <div class="col14 h100p" style="padding-right:10px">
                    <div class="caption">
                        <div>____生产工单____</div>
                        <div>当前页{{w_cur_page}}/{{w_total_page}}</div>
                    </div>
                    <div class="content w-content">
                        <el-table
                        :data="table2.tableData"
                        :border="true"
                        :stripe="true"
                        height="100%"
                        cell-style="padding-top:0px;padding-bottom:0px;">
                        <el-table-column
                        :prop="col.prop"
                        :label="col.label"
                        :min-width="col.width" v-for="(col,colix) in table2.cols" v-if="col.hide!=true">
                            <template slot-scope="scope" >
                                <template v-if="col.prop=='State'">
                                    <div v-if="scope.row.State=='正常'" style="display:flex;align-items:center;"><div  style="display:inline-block;background:green;height:18px;width:18px;border-radius:12px;"></div>&nbsp;正常</div>
                                    <div v-if="scope.row.State=='超期未完工'" style="display:flex;align-items:center;"><div  style="display:inline-block;background:red;height:18px;width:18px;border-radius:12px;"></div>&nbsp;超期未完</div>
                                    <div v-if="scope.row.State=='完工'" style="display:flex;align-items:center;"><div style="display:inline-block;background:yellow;height:18px;width:18px;border-radius:12px;"></div>&nbsp;完工</div>
                                    <div v-if="scope.row.State=='制令中止' " style="display:flex;align-items:center;"><div style="display:inline-block;background:yellow;height:18px;width:18px;border-radius:12px;"></div>&nbsp;制令中止</div>
                                    <div v-if="scope.row.State=='制令完工' " style="display:flex;align-items:center;"><div style="display:inline-block;background:yellow;height:18px;width:18px;border-radius:12px;"></div>&nbsp;制令完工</div>
                                    <div v-if="scope.row.State=='开工延期' " style="display:flex;align-items:center;"><div style="display:inline-block;background:yellow;height:18px;width:18px;border-radius:12px;"></div>&nbsp;开工延期</div>
                                </template>
                                <template v-if="col.prop!='State'">
                                    <template v-if="col.prop=='PFormMNo'">
                                        <span style="color:red;" v-if="scope.row.LtEffKpi==1">{{scope.row[col.prop]}}</span>
                                        <span v-if="scope.row.LtEffKpi!=1">{{scope.row[col.prop]}}</span>                                    
                                    </template>                             
                                    <template v-if="col.prop!='PFormMNo' ">
                                        {{scope.row[col.prop]}}  
                                    </template>                                  
                                </template>
                            </template>                    
                        </el-table-column>
                        </el-table>                
                    </div>
                </div>
                <div class="col10 h100p">
                    <div class="caption">
                        <div>____异常信息____</div>
                        <div>当前页{{m_cur_page}}/{{m_total_page}}</div>
                    </div>
                    <div class="content m-content">
                        <el-table
                            :data="table1.tableData"
                            :border="true"
                            :stripe="true"
                            height="100%"
                            cell-style="padding-top:0px;padding-bottom:0px;"
                           >
                            <el-table-column
                            :prop="col.prop"
                            :label="col.label"
                            :min-width="col.width" v-for="(col,colix) in table1.cols"   >
                                <template slot-scope="scope" >
                                    <template v-if="col.prop=='IsValid'">
                                        <div v-if="scope.row.IsValid==1" style="background:red;height:24px;width:24px;border-radius:12px;"></div>
                                        <div v-if="scope.row.IsValid==0" style="background:green;height:24px;width:24px;border-radius:12px;"></div>
                                    </template>
                                    <template v-if="col.prop!='IsValid'">
                                        {{scope.row[col.prop]}}    
                                    </template>
                                </template>
                            </el-table-column>
                        </el-table>
                    </div>
                </div>
            </div>
            <div class="row row3" style="position:relative;">
                <div  ref="chart1" style="height:100%;background-repeat:no-repeat;background-size:100% 100%;width:25%;position:absolute;left:10px;top:10px;">

                </div>
                <div  ref="chart2" style=";height:100%;background-repeat:no-repeat;background-size:100% 100%;position:absolute;left:530px;width:25%;top:10px;">
                
                </div>
                <div  style="height:100%;background-repeat:no-repeat;background-size:100% 100%;width:25%;position:absolute;left:1050px;width:43.5%;">
                    <div class="h50p" ref="chart4" style="background-repeat:no-repeat;background-size:100% 100%;position:absolute;width:100%;height:43%;top:30px;">
                    </div>
                    <div class="h50p" ref="chart5" style=";background-repeat:no-repeat;background-size:100% 100%;position:absolute;top:55%;width:100%;height:40%;">
                    </div>
                </div>
            </div>

        </div>
    </div>


<?php



?>

<script>

    axios.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded';

    let app=new Vue({
        el:'#app',
        data(){
            return {
                time:'',
                today_target:[],
                today_total_num:[],
                today_quality_num:[],
                all_total_num:[],
                all_quality_num:[],
				wo_num:[],
				uncompleted_unready_num:0,
				today_completed_num:0,
				working_postponed_num:0,
				exceeded_uncompleted_num:0,
                qualified_rate:0,
                achieving_rate:0,
                w_cur_page:0,
                w_total_page:0,
                m_cur_page:0,
                m_total_page:0,
                table1:{
                    cols:[
                        {prop:'StartTime',width:'10%',label:'呼叫时间'},
                        {prop:'EquName',width:'10%',label:'呼叫设备'},
                        {prop:'TPYE',width:'10%',label:'呼叫类别'},
                        {prop:'IsValid',width:'10%',label:'状态' ,formatter:function(row, column, cellValue, index){ if(cellValue==0){ return '<div>x</div>' ;}else{ return '<div>y</div>' }}},
                        {prop:'CountTime',width:'10%',label:'计时(分钟)'},
                        // {prop:'col0',width:'10%',label:'单号'},
                        // {prop:'col1',width:'10%',label:'品号'},
                        // {prop:'col2',width:'10%',label:'品名'},
                        // {prop:'col3',width:'10%',label:'规格'},
                        // {prop:'col4',width:'10%',label:'计划量'},
                        // {prop:'col5',width:'10%',label:'完工量'},
                        // {prop:'col6',width:'10%',label:'在制量'},
                        // {prop:'col7',width:'10%',label:'预计开工'},
                        // {prop:'col8',width:'10%',label:'预计完工'},
                        // {prop:'col9',width:'10%',label:'完工率'},
                        // {prop:'col10',width:'10%',label:'效率'},
                        // {prop:'col11',width:'10%',label:'状态'},

                    ],
                    tableData:[]
                },
                table2:{
                    cols:[
                        {prop:'col0',label:'单号'},
                        {prop:'col1',label:'品号'},
                        {prop:'col2',label:'品名'},
                        {prop:'col3',label:'规格'},
                        {prop:'col4',label:'计划量'},
                        {prop:'col5',label:'完工量'},
                        {prop:'col6',label:'在制量'},
                        {prop:'col7',label:'预计开工'},
                        {prop:'col8',label:'预计完工'},
                        {prop:'col9',label:'完工率'},
                        {prop:'col10',label:'效率'},
                        {prop:'col11',label:'状态'}                        
                    ],
                    tableData:[]
                }


            }
        },
        created(){
            this.active();
            this.getData();
            this.getMessage();
            this.getTime();
            //this.$loading({ fullscreen: true });
        },
        mounted(){

            this.renderChart1({qualified_rate:this.qualified_rate,achieving_rate:this.achieving_rate})
            this.renderChart2({})
            this.renderChart3({})
            this.renderChart4({})
            this.renderChart5({})
                // // 基于准备好的dom，初始化echarts实例
                // console.log(this.$refs.chart)
                // var myChart = echarts.init(this.$refs.chart);

                // // 指定图表的配置项和数据
                // var option = {
                //     title: {
                //         text: 'ECharts 入门示例'
                //     },
                //     tooltip: {},
                //     legend: {
                //         data:['销量']
                //     },
                //     xAxis: {
                //         data: ["衬衫","羊毛衫","雪纺衫","裤子","高跟鞋","袜子"]
                //     },
                //     yAxis: {},
                //     series: [{
                //         name: '销量',
                //         type: 'bar',
                //         data: [5, 20, 36, 10, 10, 20]
                //     }]
                // };

                // // 使用刚指定的配置项和数据显示图表。
                // myChart.setOption(option);
        },
        methods:{

            getTime(){
                let that=this
                axios.get('module/getTime.php')
                    .then((res)=>{
                        if(res.data.code==200){
                            that.time=res.data.time;
                            setTimeout(function(){that.getTime()},1000)                                                       
                        }
                    }).catch(function(res){
 
                        that.$message({
                        type:'error',
                        message:'请求失败'
                        })                        
                    })
            },
            getMessage(){
                let that=this
                axios.get('module/getMessage.php',{params:{page:parseInt(that.m_cur_page)+1}})
                    .then((res)=>{
                        if(res.data.code==200){
                            that.table1.tableData=res.data.messages;
                            that.m_total_page=res.data.total_page;
                            that.m_cur_page=res.data.cur_page; 
                            setTimeout(function(){that.getMessage()},<?php echo isset($config['parameters']['table_interval'])?$config['parameters']['table_interval']:'10' ?>*1000)                                                       
                        }
                    }).catch(function(res){
 
                        that.$message({
                        type:'error',
                        message:'请求失败'
                        })                        
                    })
            },
            getData(){
                let that=this;
                const params = new URLSearchParams();
                params.append('param1', 'value1');
                params.append('param2', 'value2');
                axios.get('module/getData.php',{params:{page:parseInt(that.w_cur_page)+1}}).then(function(res){
                    if(res.data.code==200){
                        that.table2.cols=res.data.cols;
                        that.table2.tableData=res.data.tdata;
                        that.w_total_page=res.data.total_page;
                        that.w_cur_page=res.data.cur_page;
                        setTimeout(function(){that.getData()},<?php echo isset($config['parameters']['table_interval'])?$config['parameters']['table_interval']:'10' ?>*1000)
                    }


                }).catch(function(res){
 
                    that.$message({
                        type:'error',
                        message:'请求失败'
                    })
                })
            },
            renderChart1(data){
                let that=this                
                    axios.get('module/getProducingLineProfile.php')
                        .then((res)=>{
                       
                            if(res.data.code==200){
                                let myChart = echarts.init(this.$refs.chart1);
                                let option = {
                                        title:{
                                            text:'产线状况',
                                            textStyle:{
                                                color:'#fff'
                                            },
                                            top:'10%',
                                            left:'10%'
                                        },
                                        tooltip:{
                                            show:true,
                                            formatter:function(data){
                                                return data.value+'%';
                                            }
                                        },                                                                               
                                        legend: {
                                            orient: 'vertical',
                                            right: 30,
                                            bottom:'20%',
                                            data: ['良率', '效率', '完工率'],
                                            textStyle:{
                                                color:'#fff'
                                            }
                                        },
                                        color:['#81d3fa','#fff796','#f49c75'],
                                        series: [
                                            {
                                                name: '良率',
                                                type: 'pie',
                                                radius: ['60%', '65%'],
                                                center: ['40%', '55%'],
                                                startAngle:90,
                                                labelLine: {
                                                    show: false
                                                },
                                                label:{
                                                    show:false
                                                },
                                                itemStyle:{
                                                    color:function(s){
                                                        let ix=s.dataIndex 
                                                        if(ix==0){
                                                            return '#81d3fa'
                                                        }else{
                                                            return '#b1a8a1'
                                                        }
                                                    }
                                                },


                                                data: [
                                                    {
                                                        value: Math.round(res.data.qualified_rate*10000)/100,
                                                        name: '良率',
                                                        label: {
                                                                show:true,
                                                                color:'#fff',
                                                                formatter:function(s){
                                                                    return s.data.value+'%';
                                                                },
                                                                position:'outside',
                                                                textStyle:{
                                                                    color:'#fff'
                                                                }    
                                                            },                                
                                                        labelLine: {
                                                                show: true,
                                                                // length:'25',
                
                                                                lineStyle:{
                                                                    color:'#fff'
                                                                }
                                                            }
                                                    },
                                                    {value: Math.round((1-res.data.qualified_rate)*10000)/100, name: '不良'}


                                                ]
                                            },
                                            {
                                                name: '效率',
                                                type: 'pie',
                                                radius: ['50%', '55%'],
                                                center: ['40%', '55%'],
                                                labelLine: {
                                                    show: false
                                                },
                                                label:{
                                                    show:false
                                                },                                
                                                itemStyle:{
                                                    color:function(s){
                                                        let ix=s.dataIndex 
                                                        if(ix==0){
                                                            return '#fff796'
                                                        }else{
                                                            return '#b1a8a1'
                                                        }
                                                    }
                                                },                                 
                                                data: [
                                                    {
                                                    value:Math.round(res.data.eff_rate*10000)/100,
                                                    name: '效率',
                                                    label:{
                                                        show:true,
                                                        formatter:function(s){
                                                        return s.data.value+"%";
                                                        },
                                                        position: 'outside',
                                                        textStyle:{
                                                            color:'#fff'
                                                        }                                    
                                                    },                              
                                                    labelLine: {
                                                            show: true,
                                                            length:'35',
                                                            // length2:'20',
                                                            lineStyle:{
                                                                color:'#fff'
                                                            }
                                                        }
                                                    },                                    
                                                    {value: Math.round((1-res.data.eff_rate)*10000)/100, name: ''}

                                                ]
                                            },
                                            {
                                                name: '完工率',
                                                type: 'pie',
                                                radius: ['40%', '45%'],
                                                center: ['40%', '55%'],
                                                labelLine: {
                                                    show: false
                                                },
                                                label:{
                                                    show:false                                   
                                                },
                                                itemStyle:{
                                                    color:function(s){
                                                        let ix=s.dataIndex 
                                                        if(ix==0){
                                                            return '#77887e'
                                                        }else{
                                                            return '#f49c75'
                                                        }
                                                    }
                                                },
                                                data: [
                                                    {
                                                        value:Math.round(( 1-res.data.completed_rate)*10000)/100 ,
                                                        name:'未完工'
                                                    },                                    
                                                    {
                                                        value:Math.round(res.data.completed_rate*10000)/100,
                                                        name: '完工率',
                                                        label: {
                                                            show:true,
                                                            color:'#fff',
                                                            formatter:function(s){
                                                            return s.data.value+'%'
                                                            },
                                                            position:'outside',
                                                            textStyle:{
                                                                color:'#fff'
                                                            } 
                                                        },                                
                                                        labelLine: {
                                                            show: true,
                                                            length:'40',
                                                            // length2:'50',
                                                            lineStyle:{
                                                                color:'#fff'
                                                            }
                                                        }
                                                    }


                                                ]
                                            }

                                        ]
                                    };
                                    myChart.setOption(option);
                                    that.today_target=res.data.kpi_today_target.toString().split("");
                                    that.today_total_num=res.data.today_total_num.toString().split("");		
									that.today_quality_num=res.data.today_quality_num.toString().split("");
                                    that.all_total_num=res.data.all_total_num.toString().split("");		
									that.all_quality_num=res.data.all_quality_num.toString().split("");
                                    that.wo_num=res.data.wo_num.toString().split("");
									// that.uncompleted_unready_num=res.data.uncompleted_unready_num.toString().split("");
									// that.today_completed_num=res.data.today_completed_num.toString().split("");
									// that.working_postponed_num=res.data.working_postponed_num.toString().split("");									
									// that.exceeded_uncompleted_num=res.data.exceeded_uncompleted_num.toString().split("");	
                                    that.uncompleted_unready_num=res.data.uncompleted_unready_num;
									that.today_completed_num=res.data.today_completed_num;
									that.working_postponed_num=res.data.working_postponed_num;									
									that.exceeded_uncompleted_num=res.data.exceeded_uncompleted_num;										
                                    that.qualified_rate=res.data.qualified_rate;
                                    that.achieving_rate=res.data.achieving_rate;                                      
                            setTimeout(function(){
                                that.renderChart1()
                            },<?php echo isset($config['parameters']['interval'])?$config['parameters']['interval']:'2'?>*60*1000)
                        }
                    }).catch(function(res){
           
                        that.$message({
                        type:'error',
                        message:'请求失败'
                        })                        
                    });                    

            },
            renderChart2(data){
                    let that=this                
                    axios.get('module/getDefect.php')
                        .then((res)=>{
        
                            if(res.data.code==200){
                                    let myChart = echarts.init(this.$refs.chart2);

                                    let option = {
                                            title:{
                                                text:res.data.mode+'缺陷状况',
                                                textStyle:{
                                                    color:'#fff'
                                                },
                                                top:'10%',
                                                left:'10%'
                                            },
                                            legend: {
                                                orient: 'vertical',
                                                right: 25,
                                                bottom:'20%',
                                                data: res.data.insp['items'],
                                                textStyle:{
                                                    color:'#fff'
                                                }
                                            },

                                            color:['#c23531','#2f4554', '#61a0a8', '#d48265', '#91c7ae','#749f83',  '#ca8622', '#bda29a','#6e7074', '#546570', '#c4ccd3','#18187c','#ff9900','#9b9bb5'],
                                            series: [

                                                {
                                                    //name: res.data.mode+'缺陷状况',
                                                    type: 'pie',
                                                    radius:'60%',
                                                    center: ['40%', '55%'],
                                                    avoidLabelOverlap: true,
                                                    z:800,
                                                    startAngle:90,
                                                    labelLine: {
                                                        show: true
                                                    },
                                                    label:{
                                                        show:true,
                                                        formatter:function(s){
                                                        return s.data.value
                                                        },
                                                        position:'inside',
                                                        textStyle:{
                                                            color:'#fff'
                                                        }                                    
                                                    },
                                                    data: res.data.insp['data']
                                                },                                                
                                                {
                                                    // name: '缺陷状况',
                                                    type: 'pie',
                                                    radius:'60%',
                                                    center: ['40%', '55%'],
                                                    itemStyle:{
                                                        color:'rgba(0,0,0,0)'
                                                    } ,
                                                    z:600,
                                                    startAngle:90,
                                                    labelLine: {
                                                        show: true,
                                                        lineStyle:{
                                                                color:'#fff'
                                                            }
                                                    },
                                                    label:{
                                                        show:true,
                                                        formatter:function(s){
                                                        return s.data.value+'%'
                                                        },
                                                        position:'outside',
                                                        textStyle:{
                                                            color:'#fff'
                                                        }                                    
                                                    },
                                                    data: res.data.insp['data2']
                                                }                                    


                                            ]
                                    }; 
                                    
                                    myChart.setOption(option);                 
                                    setTimeout(function(){
                                        that.renderChart2()
                                    },<?php echo isset($config['parameters']['interval'])?$config['parameters']['interval']:'2'?>*60*1000)
                        }
                    }).catch(function(res){
 
                        that.$message({
                        type:'error',
                        message:'请求失败'
                        })                        
                    });                

            },
            renderChart3(data){
                let that=this;
                axios.get('module/getEff.php')
                        .then((res)=>{
                            if(res.data.code==200){
                                let myChart = echarts.init(this.$refs.chart3);
                                let option = {
                                        title:{
                                            text:'生产效率推移图',
                                            textStyle:{
                                                color:'#fff'
                                            },
                                            top:'10%',
                                            left:'10%'
                                        },
                                        tooltip:{
                                            show:true,
                                            trigger: 'axis'
                                        },
                                        grid: [{
                                        left: '8%',
                                        bottom: '10%',
                                        top: '23%',
                                        right: '0%'
                                        }],                                       
                                        xAxis: {
                                            type: 'category',
                                            data: res.data.timeline,
                                            boundaryGap:false,
                                            axisLabel:{show:true,color:'#fff'}
                                        },
                                        yAxis: {
                                            type: 'value',
                                            splitLine:{
                                                show:false
                                            },
                                            axisLabel:{show:true,color:'#fff'},
                                            axisLine:{
                                                show:true
                                            }
                                        },                         
                                        series: [
                                            {
                                                name: '生产效率推移图',
                                                type: 'line',
                                                smooth: true,
                                               // symbol:'none',
                                                color:['#acc782'],
                                                data: res.data.eff
                                            }

                                        ]
                                    };
                                    myChart.setOption(option);
                            
                            setTimeout(function(){
                                that.renderChart3()                              
                            },<?php echo isset($config['parameters']['interval'])?$config['parameters']['interval']:'2'?>*60*1000)
                        }
                    }).catch(function(res){
 
                        that.$message({
                        type:'error',
                        message:'请求失败'
                        })                        
                    }); 

            },
            renderChart4(data){
                let that=this;
                axios.get('module/get6days.php')
                        .then((res)=>{
                            if(res.data.code==200){
                                
                                let myChart = echarts.init(this.$refs.chart4);
                                let option = {
                                        title:{
                                            text:'日达成',
                                            textStyle:{
                                                color:'#fff'
                                            },
                                            top:'8%',
                                            left:'3%'
                                        },
                                        tooltip:{
                                            show:true,
                                            trigger: 'axis'
                                        },
                                        grid: [{
                                        left: '8%',
                                        bottom: '10%',
                                        top: '25%',
                                        right: '0%'
                                        }],                                       
                                        xAxis: {
                                            type: 'category',
                                            data: res.data.timeline,
                                            axisLabel:{show:true,color:'#fff'}
                                        },
                                        yAxis: {
                                            type: 'value',
                                            splitLine:{
                                                show:false
                                            },
                                            axisLabel:{show:true,color:'#fff'},
                                            axisLine:{
                                                show:true
                                            }
                                        },                         
                                        series: [

                                            {
                                                name: '标准',
                                                type: 'line',
                                                smooth: true,
                                               // symbol:'none',
                                                color:['#ed7d31'],
                                                data: res.data.kpiValues
                                            },
                                            
                                            {
                                                name: '实际',
                                                type: 'bar',
                                                itemStyle:{color:'#4472c4'},
                                                data: res.data.outputs
                                            }

                                        ]
                                    };
                                    myChart.setOption(option);
                            
                            setTimeout(function(){
                                that.renderChart4()                              
                            },<?php echo isset($config['parameters']['interval'])?$config['parameters']['interval']:'2'?>*60*1000)
                        }
                    }).catch(function(res){
                        console.log(res)
                        that.$message({
                        type:'error',
                        message:'请求失败'
                        })                        
                    }); 

            },
            renderChart5(data){
                let that=this;
                axios.get('module/get6months.php')
                        .then((res)=>{
                            if(res.data.code==200){

                                let myChart = echarts.init(this.$refs.chart5);
                                let option = {
                                        title:{
                                            text:'月达成',
                                            textStyle:{
                                                color:'#fff'
                                            },
                                            top:'3%',
                                            left:'3%'
                                        },
                                        tooltip:{
                                            show:true,
                                            trigger: 'axis'
                                        },
                                        grid: [{
                                        left: '8%',
                                        bottom: '10%',
                                        top: '23%',
                                        right: '0%'
                                        }],                                       
                                        xAxis: {
                                            type: 'category',
                                            data: res.data.timeline,
                                            axisLabel:{show:true,color:'#fff'}
                                        },
                                        yAxis: {
                                            type: 'value',
                                            splitLine:{
                                                show:false
                                            },
                                            axisLabel:{show:true,color:'#fff'},
                                            axisLine:{
                                                show:true
                                            }
                                        },                         
                                        series: [

                                            {
                                                name: '标准',
                                                type: 'bar',
                                                itemStyle:{color:'#ed7d31'},
                                                data: res.data.kpiValues
                                            },
                                            {
                                                name: '实际',
                                                type: 'bar',
                                                itemStyle:{color:'#4472c4'},
                                                data: res.data.outputs
                                            }
                                            


                                        ]
                                    };
                                    myChart.setOption(option);
                                    myChart.resize();
                            
                            setTimeout(function(){
                                that.renderChart5()                              
                            },<?php echo isset($config['parameters']['interval'])?$config['parameters']['interval']:'2'?>*60*1000)
                        }
                    }).catch(function(res){
 
                        that.$message({
                        type:'error',
                        message:'请求失败'
                        })                        
                    }); 

            },
            active(){
                let that=this
                axios.get("module/active.php")
                .then(function(res){
                    try{
                        let data=res.data;
                        if(data.code==0){
                            location='auth.php';
                        }
                    }catch(e){
                        console.log(e)
                    }


                    setTimeout(that.active,1000)
                })
            }

                       
        }
    })
</script>
</body>
</html>