<div id="app-hist-data" :style="{display:histDataDlgVisible?'block':'none'}">
    <el-dialog 
        :visible.sync="histDataDlgVisible"
        title="设备历史明细"
        width="80%"
    >
        <div id="hist-data-header hflex hflex-vc" style="display:flex;">
            <div class="" style="max-width:200px;overflow:hidden;text-overflow:ellipsis; white-space: nowrap;padding-right:15px; ">
                <span class="title" @click="wcDlgVisible=true">工作站：<span style="text-decoration:underline">{{wcnames}}</span></span>
            </div>
            <div class="" style="padding-right:15px;">
                <span class="title">设备：</span>
                <el-select multiple v-model="selectedEqus">
                    <el-option v-for="(item,ix) in equs"
                        :key="item.EquNo"
                        :label="item.EquName"
                        :value="item.EquNo"                        
                    >
                    </el-option>
                </el-select>
            </div>
            <div class="" style="padding-right:15px;">
                <span class="title">时间：</span>
                <el-date-picker
                    v-model="timeRange"
                    unlink-panels
                    type="datetimerange"
                    range-separator="至"
                    start-placeholder="开始日期"
                    end-placeholder="结束日期">
                </el-date-picker>
            </div>
            <el-button @click="search">查询</el-button>
        </div>
        <div id="hist-data-main">
            <el-table
                :data="tdata"
                height="350px"
                @row-click="rowClick"
                :row-style="rowStyle"
            >
                <el-table-column label="设备号" prop="EquNo"></el-table-column>
                <el-table-column label="设备名" prop="EquName"></el-table-column>
                <el-table-column label="报工时间" prop="WorkTime"></el-table-column>
                <el-table-column label="工作站" prop="CenterName"></el-table-column>
                <el-table-column label="开机时间(秒)" prop="AllTime"></el-table-column>
                <el-table-column label="运行时间(秒)" prop="RunTime"></el-table-column>
                <el-table-column label="当前产量" prop="EquNum"></el-table-column>
                <el-table-column label="时间稼动率" prop="TimeRunRate"></el-table-column>
                <el-table-column label="今日产量" prop="TodayEquNum"></el-table-column>
                <el-table-column label="产能利用率" prop="CapacityUsageRate"></el-table-column>
            </el-table>
            <el-pagination
                @current-change="handleCurrentChange"
                :current-page.sync="curpage"
                :page-size="pageSize"
                layout="prev, pager, next"
                :total="total">
            </el-pagination>
        </div>
        <div id="hist-data-chart" v-if="tdata.length>0">
            <div class="col20-20  padlf5 padtb5" style="height:250px">
                <div id="chartFsCnsStatus1" ref="chartFsCnsStatus1" class="w100p h100p"></div>
            </div>
        </div>
    </el-dialog>
    <el-dialog
        title="提示"
        :visible.sync="wcDlgVisible"
        @open="wcOpen"
        width="30%" >
        <div style="width:100%;height:600px;overflow:auto">
            <el-tree :data="workcenterTree" :props=" { children: 'children', label: 'label' } " show-checkbox node-key="id" :default-checked-keys="checkedKeys" ref="tree" :default-expand-all="true"></el- tree>    
        </div>
        <span slot="footer" class="dialog-footer">
        <el-button @click="wcDlgVisible = false">取 消</el-button> 
            <el-button type="primary" @click="handleWcDlgClose">确 定</el-button> 
        </span>                                                       
    </el-dialog>  
</div>