appNormalBodyOption={
    data(){
        return {
            time:'',
            curDeviceName:'',
            autorun:0,
            autorun2:'0%',
            autostop:0,
            autostop2:'0%',
            prepare:0,
            prepare2:'0%',
            warntime:0,
            warntime2:'0%',
            closetime:0,
            closetime2:'0%',         
            dialogVisible:false,
            devices:[],
            totalDevicesNum:0,
            runDevicesNum:0,
            stopDevicesNum:0,
            failDevicesNum:0,
            blackoutDevicesNum:0,
            devicePage:0,
            totalDevicesNum:0,
            totalDevicesPage:0,
            curDeviceIx:0,
            autorun:0,
            autostop:0,
            show_prospec:'show',
            show_device_name:'show',
            checkedKeys:[],
            getDevicesHandle:null,
            deviceChangeHandle:null,
            getCurDeviceInfoHandle:null,
            getWorkCenterInfoHandle:null,
            workcenterTree:[],
            defaultProps: { children: 'children', label: 'label' },
            ...commonOption,
            getDevicesCounter:0
        }
    },
    created(){
        
    },
    mounted(){
        let that=this
        this.getWorkCenterInfo();
        this.getDevices(function(){

            if(that.totalDevicesNum!=0){
                that.devicePage=1;
            }   
            that.getCurDeviceInfo();             
            that.deviceChangeHandle=setTimeout(that.deviceChange,1000*that.config['interval_device_change']);
            
        });

    },
    methods:{
        init(){
            let that=this
            this.getWorkCenterInfo();
            this.getDevices(function(){
                that.getCurDeviceInfo();             
                that.deviceChangeHandle=setTimeout(that.deviceChange,1000*that.config['interval_device_change']);
                
            });
        },
        show(){
            let that=this
            this.$el.style.display='block'
            this.$nextTick(()=>{
                that.init()
            })

        },
        hide(){
            this.$el.style.display='none'
        },
        pageChange(e){
            clearTimeout(this.deviceChangeHandle);
            this.deviceChangeHandle=setTimeout(this.deviceChange,1000*15);
        },
        enableFullsrn(){
            let that=this          
             clearTimeout(that.getDevicesHandle)
             clearTimeout(that.deviceChangeHandle);
             clearTimeout(that.getCurDeviceInfoHandle);
             clearTimeout(that.getWorkCenterInfoHandle);
             this.hide()
             document.querySelector('html').requestFullscreen()
             appStack.push(appFullsrn)
             appFullsrn.init({
                devicePage:this.devicePage,
                curDeviceIx:this.curDeviceIx,
                wcids_right:this.wcids_right
             })
             appFullsrn.show()

        },	
        openHisDataDlg(){
            appHistData.show()
        },
        deviceChange(){
            if(this.totalDevicesNum!=0){
                this.curDeviceIx++;  
                if(this.curDeviceIx>=this.totalDevicesNum){
                    this.curDeviceIx=0;
                }                     
                this.getCurDeviceInfo();  
                this.devicePage=Math.ceil((this.curDeviceIx+1)/20);

            }

            this.deviceChangeHandle=setTimeout(this.deviceChange,1000*this.config['interval_device_change']);
            
        },
        timeChange(){
            //时间变化只影响工作站统计，设备列表按当前的情况获取
            if(this.starttime.getTime()>this.endtime.getTime()){
                alert('非法时间区间');
                if(this.starttime.getTime()!=this.laststarttime.getTime()){
                    this.starttime=this.laststarttime;
                }else{
                    this.endtime=this.lastendtime;
                }
                return;
            }else{
                if(this.starttime.getTime()!=this.laststarttime.getTime()){
                    this.laststarttime=this.starttime;
                }else{
                    this.lastendtime=this.endtime;
                }
            }
            //clearTimeout(this.getDevicesHandle);
            //this.getDevices();
            clearTimeout(this.getWorkCenterInfoHandle)
            this.getWorkCenterInfo();
        },         
        changeCurDevice(ix){
            clearTimeout(this.getCurDeviceInfoHandle);
            clearTimeout(this.deviceChangeHandle);
            this.curDeviceIx=ix;
            this.getCurDeviceInfo();
            this.deviceChangeHandle=setTimeout(this.deviceChange,1000*5);
        },

        handleClose(){
            let wcids=this.$refs.tree.getCheckedNodes()
            let t=new Array();
            let t2=new Array();
            for(let i=0;i<wcids.length;i++){
                if(wcids[i]['id'].indexOf('c-')!=-1){
                    t.push(wcids[i]['id'].split('-')[1]);
                    t2.push(wcids[i]['label']);
                }
            }
            this.wcids_right=t;
            this.wcnames_right=t2.join(",");
            clearTimeout(this.getDevicesHandle);
            let that=this
            that.getDevicesCounter=0
            this.getDevices(function(){
                clearTimeout(that.deviceChangeHandle);
                clearTimeout(that.getCurDeviceInfoHandle);
                clearTimeout(that.getWorkCenterInfoHandle);
                that.curDeviceIx=0
                if(that.totalDevicesNum!=0){
                    that.devicePage=1;
                } 

                that.getCurDeviceInfo(); 
                that.getWorkCenterInfo();               
                that.deviceChangeHandle=setTimeout(that.deviceChange,1000*that.config['interval_device_change']);

            });
            this.dialogVisible=false;
        },
        openDlg(){
            let that=this;
            axios.get('module/getWD.php').then((res)=>{ 
                that.workcenterTree=res.data.tree;
                let keys=that.wcids_right.map(function(v){
                    v="c-"+v;
                    return v;
                })
                that.checkedKeys=keys;
            })               
        },
        getDevices(f){
            let that=this;
            const params = new URLSearchParams();
                params.append('wcids', this.wcids_right);
                params.append('starttime', this.starttime.getTime()/1000);  
                params.append('endtime', this.endtime.getTime()/1000); 
            let onlyStatus=0
                if(that.getDevicesCounter==0 && this.mode=='SCADA'){
                    onlyStatus=0
                }else{
                    onlyStatus=1
                }  
                params.append('onlyStatus',onlyStatus)

                that.getDevicesCounter++
                if(that.getDevicesCounter>(60*that.config['interval_devices_refresh']/3)){
                    that.getDevicesCounter=0
                }

                axios.post('module/getDevices.php',params).then((res)=>{   

                    if(res.data.code==1){
                        let data=res.data.data
                        that.show_device_name=data.show_device_name;
                        that.show_prospec=data.show_prospec;  
                        if(onlyStatus==1){
                             let equs={}
                             data.devices.forEach(v=>{
                                equs[v.EquNo]=v
                             })
                             let tDevices=[]
                             
                            that.devices.forEach(element => {
                                let equNo=element.EquNo
                                if(equs[equNo]!=undefined){
                                    that.$set(element,'status',equs[equNo].status)
                                    tDevices.push(element)
                                }

                             });
                             that.devices=tDevices
                             
                        }else{
                            console.log(onlyStatus)
                            that.devices=data.devices;
                        }                    
                     
                        let totalDevicesNum=that.devices.length;
                        that.totalDevicesNum=totalDevicesNum;
                        let totalDevicesPage=Math.ceil(totalDevicesNum/20);
                        that.totalDevicesPage=totalDevicesPage;

                        let runNum=0;
                        let stopNum=0;
                        let failNum=0;
                        let blackout=0;
    
                       
                        for(let i=0;i<that.devices.length;i++){
                            if(that.devices[i].status=='green'){
                                runNum++;
                            }
                            if(that.devices[i].status=='red'){
                                stopNum++;
                            }
                            if(that.devices[i].status=='yellow'){
                                failNum++;
                            }
                            if(that.devices[i].status=='gray'){
                                blackout++;
                            }                                                                                    
                        }
                        that.runDevicesNum=runNum;
                        that.stopDevicesNum=stopNum;
                        that.failDevicesNum=failNum;
                        that.blackoutDevicesNum=blackout
                        if(f!=undefined){
                            f();
                        }
                        // loading.close();
                        that.getDevicesHandle=setTimeout(function(){
                            that.getDevices();
                        },1000*3);

                    }else{
                        throw new Error(res.data.msg);
                    }

                }).catch(function(res){
                    //loading.close();
                    console.log(res)
                    that.$message({
                    type:'error',
                    message:'请求失败'
                    })                        
                })
        },
        getCurDeviceInfo(){
            let that=this;
            if(this.devices.length==0){     
                that.getCurDeviceInfoHandle=setTimeout(function(){
                        that.getCurDeviceInfo();
                    },1000);               
                return;
            }
            if(this.devices.length<=this.curDeviceIx){              
                that.curDeviceIx=0;
            }

            let curDevice=this.devices[this.curDeviceIx];
            this.curDeviceName=curDevice['EquName'];
            axios.get('module/getCurDeviceInfo.php',{
                params:{
                    equNo:curDevice['EquNo'],
                    starttime:this.starttime.getTime()/1000,
                    endtime:this.endtime.getTime()/1000                       
                }
            }).then((res)=>{
                
                that.autorun=res.data.autoRun;
                that.autorun2=res.data.autoRun2;
                that.autostop=res.data.autoStop;
                that.autostop2=res.data.autoStop2;
                that.warntime=res.data.warnTime;
                that.warntime2=res.data.warnTime2;
                that.closetime=res.data.closeTime;
                that.closetime2=res.data.closeTime2;
                that.prepare=res.data.prepare;
                that.prepare2=res.data.prepare2;
                that.$nextTick(()=>{
                        try{
                            let myChart = echarts.init(that.$refs.chart4);
                            let option = {
                                    title:{
                                        text:'',
                                        textStyle:{
                                            color:'#fff'
                                        },
                                        top:'10%',
                                        left:'10%'
                                    },
                                    tooltip:{
                                        show:true,
                                        trigger: 'axis'
                                    },
                                    legend:{
                                        show:true,
                                        data:['产量','运转率'],
                                        icon:'rect',
                                        right:10,
                                        top:'45%',
                                        type: 'scroll',
                                        orient: 'vertical',
                                        itemHeight:10,
                                        textStyle:{
                                            color:'white',
                                            fontSize:'16px'
                                        }
                                    },
                                    grid: [{
                                    left: '10%',
                                    bottom: '18%',
                                    top: '23%',
                                    right: '20%'
                                    }],                                       
                                    xAxis: {
                                        type: 'category',
                                        data: res.data.timeline,
                                        splitNumber:8,
                                        axisLabel:{show:true,color:'#fff',rotate:45}
                                    },
                                    yAxis: [{
                                        type: 'value',
                                        name:'产量',
                                        nameTextStyle:{
                                            color:'#fff'
                                        },
                                        splitLine:{
                                            show:false
                                        },
                                        axisLabel:{show:true,color:'#fff'},
                                        axisLine:{
                                            show:true
                                        }
                                    }, {
                                        type: 'value',
                                        name:'运转率(%)',
                                        nameTextStyle:{
                                            color:'#fff'
                                        },
                                        splitLine:{
                                            show:false
                                        },
                                        
                                        axisLabel:{show:true,color:'#fff',formatter:(v)=> v*100,},
                                        axisLine:{
                                            show:true
                                        }
                                    }],                         
                                    series: [
                                        {
                                            name: '产量',
                                            type: 'line',
                                            smooth: true,
                                            // symbol:'none',
                                            color:['#0d7334'],
                                            data: res.data.outputs,
                                            yAxisIndex:0
                                        },
                                        {
                                            name: '运转率',
                                            type: 'line',
                                            smooth: true,
                                            color:['#cb0000'],
                                            data: res.data.runrates,
                                            yAxisIndex:1
                                        }
                                    ]
                                };
                                myChart.setOption(option);
                                myChart.resize()
                    
                        }catch(e){
                            console.log(e,that.$refs)
                        }
                    })

                    // that.getCurDeviceInfoHandle=setTimeout(function(){
                        // that.getCurDeviceInfo();
                    // },1000);
            })
        },
        getWorkCenterInfo(){
            let that=this;
            axios.get('module/getWorkCenterInfo.php',{
                params:{
                    starttime:this.starttime.getTime()/1000,
                    endtime:this.endtime.getTime()/1000
                }
            }).then(res=>{
                
                that.renderChart1(res.data);
                that.renderChart2(res.data.wc8h);
                that.renderChart3(res.data.wc8h);
                that.getWorkCenterInfoHandle=setTimeout(function(){
                    that.getWorkCenterInfo()
                },that.config['interval_left']*1000*60);
            })                
        },
        renderChart1(data){
            let that=this                
            let myChart = echarts.init(this.$refs.chart1);
            let option = {
                        title:{
                            text:'',
                            textStyle:{
                                color:'#fff'
                            },
                            top:'10%',
                            left:'10%'
                        },
                        grid: [{
                        left: '10%',
                        bottom: '5%',
                        top: '25%',
                        right: '20%'
                        }],                       
                        series: [
                            {
                                type: 'gauge',
                                center:['20%','25%'],
                                radius:'40%',
                                axisLine: {
                                    lineStyle: {
                                        width: 10,
                                        color: [
                                            [0.2,'#fe0902'],
                                            [0.4,'#fe8702'],
                                            [0.6,'#fed103'],
                                            [0.8, '#dcff41'],
                                            [1, '#93f005']
                                        ]
                                    }
                                }, 
                                pointer:{
                                    itemStyle:{
                                        color:'silver'
                                    }
                                },
                                axisLabel:{
                                    show:false
                                },
                                splitLine:{
                                    show:false
                                },
                                axisTick:{
                                    show:false
                                },                                                                                                            
                                detail: {
                                    valueAnimation: true,
                                    formatter: '{value}%良率',
                                    color: 'white',
                                    fontSize:12,
                                    offsetCenter:[0,'80%'],
                                },
                                data: [{
                                    value: data.QualityRate
                                }]
                            },
                            {
                                type: 'gauge',
                                center:['60%','25%'],
                                radius:'40%',
                                axisLine: {
                                    lineStyle: {
                                        width: 10,
                                        color: [
                                            [0.2,'#fe0902'],
                                            [0.4,'#fe8702'],
                                            [0.6,'#fed103'],
                                            [0.8, '#dcff41'],
                                            [1, '#93f005']
                                        ]
                                    }
                                },
                                pointer:{
                                    itemStyle:{
                                        color:'silver'
                                    }
                                },									
                                axisLabel:{
                                    show:false
                                },
                                splitLine:{
                                    show:false
                                },
                                axisTick:{
                                    show:false
                                },                                                                        
                                detail: {
                                    valueAnimation: true,
                                    formatter: '{value}% 效率',
                                    color: 'white',
                                    fontSize:12,
                                    offsetCenter:[0,'80%'],
                                },
                                data: [{
                                    value: data.Eff
                                }]
                            },
                            {
                                type: 'gauge',
                                center:['20%','75%'],
                                radius:'40%',
                                axisLine: {
                                    lineStyle: {
                                        width: 10,
                                        color: [
                                            [0.2,'#fe0902'],
                                            [0.4,'#fe8702'],
                                            [0.6,'#fed103'],
                                            [0.8, '#dcff41'],
                                            [1, '#93f005']
                                        ]
                                    }
                                },
                                pointer:{
                                    itemStyle:{
                                        color:'silver'
                                    }
                                },									
                                axisLabel:{
                                    show:false
                                },
                                splitLine:{
                                    show:false
                                },
                                axisTick:{
                                    show:false
                                },                                     
                                detail: {
                                    valueAnimation: true,
                                    formatter: '{value}% 完工率',
                                    color: 'white',
                                    fontSize:12,
                                    offsetCenter:[0,'80%'],
                                },
                                data: [{
                                    value: data.CompleteRate
                                }]
                            },
                            {
                                type: 'gauge',
                                center:['60%','75%'],
                                radius:'40%',
                                axisLabel:{
                                    show:false
                                },
                                splitLine:{
                                    show:false
                                },
                                axisTick:{
                                    show:false
                                },
                                pointer:{
                                    itemStyle:{
                                        color:'silver'
                                    }
                                },									
                                axisLine: {
                                    lineStyle: {
                                        width: 10,
                                        color: [
                                            [0.2,'#fe0902'],
                                            [0.4,'#fe8702'],
                                            [0.6,'#fed103'],
                                            [0.8, '#dcff41'],
                                            [1, '#93f005']
                                        ]
                                    }
                                },                                    
                                detail: {
                                    valueAnimation: true,
                                    formatter: '{value}% 开机率',
                                    color: 'white',
                                    fontSize:12,
                                    offsetCenter:[0,'80%'],
                                },
                                data: [{
                                    value: data.OpenRate
                                }]
                            }                                    
                        ]
                    };
                    myChart.setOption(option);         
                    myChart.resize()        

        },
        renderChart2(data){
                let that=this                
                let myChart = echarts.init(this.$refs.chart2);
                let option = {
                            title:{
                                text:'产量',
                                textStyle:{
                                    color:'#fff'
                                },
                                top:'0%',
                                left:'40%'
                            },
                            grid: [{
                            left: '10%',
                            bottom: '18%',
                            top: '18%',
                            right: '20%'
                            }],                       
                            xAxis: {
                                type: 'category',
                                data: data.timeline,
                                splitNumber:8,
                                axisLabel:{show:true,color:'#fff',rotate:25,fontSize:'12px'}
                            },
                            yAxis: {
                                type: 'value',
                                splitLine:{
                                    show:false
                                },
                                axisLabel:{show:true,color:'#fff'},
                                axisLine:{
                                    show:true
                                }                                   
                            },
                            series: [{
                                data: data.plan,
                                type: 'bar',
                                label:{
                                    show:true,
                                    position:'top',
                                    color:'white'
                                },
                                itemStyle:{color:'yellow'}
                            },{
                                data: data.real,
                                type: 'bar',
                                label:{
                                    show:true,
                                    position:'top',
                                    color:'white'
                                },
                                itemStyle:{color:'green'}
                            }]
                        };
                        myChart.setOption(option); 
                        myChart.resize()          

        },
        renderChart3(data){
            let that=this;
            let myChart = echarts.init(this.$refs.chart3);
                let option = {
                        title:{
                            text:'生成效率推移',
                            textStyle:{
                                color:'#fff'
                            },
                            top:'0%',
                            left:'35%'
                        },
                        tooltip:{
                            show:true,
                            trigger: 'axis'
                        },
                        legend:{
                            show:true,
                            data:['效率','稼动率'],
                            icon:'rect',
                            bottom:10,
                            type: 'scroll',
                            bottom:'1%',
                            itemHeight:3,
                            itemGap:120,
                            textStyle:{
                                color:'white',
                                fontSize:'12px'
                            }
                        },
                        grid: [{
                        left: '10%',
                        bottom: '25%',
                        top: '18%',
                        right: '10%'
                        }],                                       
                        xAxis: {
                            type: 'category',
                            data: data.timeline,
                            splitNumber:8,
                            axisLabel:{show:true,color:'#fff',rotate:25,fontSize:'12px'}
                        },
                        yAxis: {
                            type: 'value',
                            name: '效率',
                            nameTextStyle:{
                                color:'#fff'
                            },
                            splitLine:{
                                show:false
                            },

                            axisLabel:{show:true,color:'#fff',formatter:function(v){ return v*100+'%';}},
                            axisLine:{
                                show:true
                            }
                        },                         
                        series: [
                            {
                                name: '效率',
                                type: 'line',
                                smooth: true,
                                // symbol:'none',
                                color:['#cb0000'],
                                data: data.eff,
                                yAxisIndex:0
                            },
                            {
                                name: '稼动率',
                                type: 'line',
                                smooth: true,
                                color:['#fbf531'],
                                data: data.run,
                                yAxisIndex:0
                            }
                        ]
                    };
                    myChart.setOption(option);
                    myChart.resize()
        }
        
    }
}
let appNormalBody=new Vue(appNormalBodyOption)