let appHistData=new Vue({
    data(){
        return {          
            histDataDlgVisible:false,
            wcDlgVisible:false,
            workcenterTree:[],
            defaultProps:{},
            checkedKeys:[],
            wcnames:'请选择',
            wcids:[],
            equs:[],
            selectedEqus:[],
            timeRange:[],
            curpage:0,
            pageSize:15,
            total:0,
            tdata:[],
            currentRow:{}
        }
    },
    created(){
        
    },
    mounted(){
        let that=this       
        this.getAutoWorkRecords(1)
           
    },
    computed:{

    },
    methods:{
        getDeviceData1(equNo,date){
            let that=this 
            return axios.get('module/getMachineStatuses.php',{params:{equNo,date}}).then(res=>{
                if(res.data.code==1){
                    that.machineId=res.data.data.machineId;
                    let statusesConfig={
                        AUTO_RUN:{
                            color:'#0b5f01',
                            label:'工作'
                        },
                        OFF:{
                            color:'#ababab',
                            label:'停机'
                        },
                        WAIT:{
                            color:'#a38c14',
                            label:'待机'
                        },                            
                        EMERGENCY:{
                            color:'#ff0000',
                            label:'急停'
                        },
                        MANUAL:{
                            color:'#377aab',
                            label:'手动'
                        }                                                                                  
                    }
                    let statusesAutoWork=res.data.data.cncStatuses.filter((e)=>{
                       return e[3]=='AUTO_RUN'
                    })
                    let statusesOff=res.data.data.cncStatuses.filter((e)=>{
                       return e[3]=='OFF'
                    })
                    let statusesWait=res.data.data.cncStatuses.filter((e)=>{
                       return e[3]=='WAIT'
                    })
                    let statusesEmergency=res.data.data.cncStatuses.filter((e)=>{
                       return e[3]=='EMERGENCY'
                    })
                    let statusesManual=res.data.data.cncStatuses.filter((e)=>{
                       return e[3]=='MANUAL'
                    })

                    let renderFun=function (params, api) {

                        let startPoint=api.coord([api.value(0),1])
                        let endPoint=api.coord([api.value(2),0])
                        let status=api.value(3)
                        let fillColor=statusesConfig[status].color
                        return {
                            type: 'rect',
                            shape: {
                                x: startPoint[0],
                                y: startPoint[1],
                                width: endPoint[0]-startPoint[0],
                                height: api.size([0,1])[1]
                            },
                            style:api.style({
                                fill:fillColor
                            })
                        };
                    }
                    if(res.data.frommdc==true){
                        that.$nextTick(()=>{
                            let myChart3 = echarts.init(that.$refs.chartFsCnsStatus1);                          
                                option3 = {
                                    title: {
                                        text: '机台状态',
                                        textStyle:{
                                            color:'#fff'
                                        }
                                    },
                                    tooltip: {
                                        trigger:'item',
                                        formatter:function(params){
                                           let status=params.data[3]
                                           let st=params.data[0]
                                           let en=params.data[2]
                                           if(statusesConfig[status]!=null){
                                                let html='<ul>'
                                                    html+='<li>'
                                                    html+=statusesConfig[status].label
                                                    html+='</li>'
                                                    html+='<li>'
                                                    html+=st
                                                    html+='</li>'
                                                    html+='<li>'
                                                    html+=en
                                                    html+='</li>'                                                                                                
                                                    html+='</ul>'
                                                return html
                                           }else{
                                                return '不支持的类型'
                                           }
                                           
                                        }
                                    },
                                    grid:[
                                        {
                                            left:0,
                                            right:0
                                        }
                                    ],
                                    xAxis: {
                                        type:'time',
                                        scale: true,
                                        axisLabel:{
                                            formatter:function(value){
                                                return moment(value).format("HH")+'时'
                                            }
                                        },
                                        max:'dataMax'
                                    },
                                    legend:{
                                        data:[
                                            {
                                                name:'工作',
                                                icon:'rect',
                                                itemStyle:{
                                                    color:'#0b5f01'
                                                }
                                            },
                                            {
                                                name:'停机',
                                                icon:'rect',
                                                itemStyle:{
                                                    color:'#ababab'
                                                }
                                            },
                                            {
                                                name:'待机',
                                                icon:'rect',
                                                itemStyle:{
                                                    color:'#a38c14'
                                                }
                                            },
                                            {
                                                name:'急停',
                                                icon:'rect',
                                                itemStyle:{
                                                    color:'#ff0000'
                                                }
                                            },
                                            {
                                                name:'手动',
                                                icon:'rect',
                                                itemStyle:{
                                                    color:'#377aab'
                                                }
                                            }
                                        ]
                                    },
                                    yAxis: {
                                        show:false,
                                        max:1
                                    },
                                    series: [
                                        {
                                            type: 'custom',
                                            name:'工作',
                                            renderItem: renderFun,
                                            data: statusesAutoWork
                                        },
                                        {
                                            type: 'custom',
                                            name:'停机',
                                            renderItem: renderFun,
                                            data: statusesOff
                                        },
                                        {
                                            type: 'custom',
                                            name:'待机',
                                            renderItem: renderFun,
                                            data: statusesWait
                                        },
                                        {
                                            type: 'custom',
                                            name:'急停',
                                            renderItem: renderFun,
                                            data: statusesEmergency
                                        },
                                        {
                                            type: 'custom',
                                            name:'手动',
                                            renderItem: renderFun,
                                            data: statusesManual
                                        }
                                    ]
                                };
    
                                myChart3.setOption(option3);  
                                myChart3.resize();
                        
                        })
                       

                    }else{

                        statusesConfig={
                            RUN:{
                                color:'#0b5f01',
                                label:'工作'
                            },
                            OFF:{
                                color:'#ababab',
                                label:'断电停机'
                            },
                            WARNING:{
                                color:'#a38c14',
                                label:'报警停机'
                            },                            
                            EMERGENCY:{
                                color:'#ff0000',
                                label:'停止停机'
                            }                                                                                  
                        }
        
                        let statusesWork=res.data.data.cncStatuses.filter((e)=>{
                            return e[3]=='RUN'
                         })

                        let statusesWarning=res.data.data.cncStatuses.filter((e)=>{
                            return e[3]=='WARNING'
                         })
    

                         that.$nextTick(()=>{
                            let myChart3 = echarts.init(that.$refs.chartFsCnsStatus1);                          
                                option3 = {
                                    title: {
                                        text: '机台状态',
                                        textStyle:{
                                            color:'#fff'
                                        }
                                    },
                                    tooltip: {
                                        trigger:'item',
                                        formatter:function(params){
                                           let status=params.data[3]
                                           let st=params.data[0]
                                           let en=params.data[2]
                                           if(statusesConfig[status]!=null){
                                                let html='<ul>'
                                                    html+='<li>'
                                                    html+=statusesConfig[status].label
                                                    html+='</li>'
                                                    html+='<li>'
                                                    html+=st
                                                    html+='</li>'
                                                    html+='<li>'
                                                    html+=en
                                                    html+='</li>'                                                                                                
                                                    html+='</ul>'
                                                return html
                                           }else{
                                                return '不支持的类型'
                                           }
                                           
                                        }
                                    },
                                    grid:[
                                        {
                                            left:0,
                                            right:0
                                        }
                                    ],
                                    xAxis: {
                                        type:'time',
                                        scale: true,
                                        axisLabel:{
                                            formatter:function(value){
                                                return moment(value).format("HH")+'时'
                                            }
                                        },
                                        max:'dataMax'
                                    },
                                    legend:{
                                        data:[
                                            {
                                                name:'工作',
                                                icon:'rect',
                                                itemStyle:{
                                                    color:'#0b5f01'
                                                }
                                            },
                                            {
                                                name:'断电停机',
                                                icon:'rect',
                                                itemStyle:{
                                                    color:'#ababab'
                                                }
                                            },
                                            {
                                                name:'报警停机',
                                                icon:'rect',
                                                itemStyle:{
                                                    color:'#a38c14'
                                                }
                                            },
                                            {
                                                name:'停止停机',
                                                icon:'rect',
                                                itemStyle:{
                                                    color:'#ff0000'
                                                }
                                            }
                                        ]
                                    },
                                    yAxis: {
                                        show:false,
                                        max:1
                                    },
                                    series: [
                                        {
                                            type: 'custom',
                                            name:'工作',
                                            renderItem: renderFun,
                                            data: statusesWork
                                        },
                                        {
                                            type: 'custom',
                                            name:'断电停机',
                                            renderItem: renderFun,
                                            data: statusesOff
                                        },
                                        {
                                            type: 'custom',
                                            name:'报警停机',
                                            renderItem: renderFun,
                                            data: statusesWarning
                                        },
                                        {
                                            type: 'custom',
                                            name:'停止停机',
                                            renderItem: renderFun,
                                            data: statusesEmergency
                                        }
                                    ]
                                };
    
                                myChart3.setOption(option3);  
                                myChart3.resize();
                        
                        })
                    }



               
                }else{

                }

            }).catch(err=>{
                console.log(err)
            }).then((res)=>{
                // that.getDeviceData1Handle=setTimeout(function(){
                //     that.getDeviceData1(machineId)
                // },30*1000)
            })
        },
        init(option){
            let that=this
            for(let i in option){
                this[i]=option[i]
            }
        },
        show(){
            this.histDataDlgVisible=true
        },
        wcOpen(){
            let that=this;
            axios.get('module/getWD.php').then((res)=>{ 
                that.workcenterTree=res.data.tree;
                let keys=that.wcids.map(function(v){
                    v="c-"+v;
                    return v;
                })
                that.checkedKeys=keys;
            })       
        },
        handleWcDlgClose(){
            let that=this
            let wcids=this.$refs.tree.getCheckedNodes()
            let t=new Array();
            let t2=new Array();
            for(let i=0;i<wcids.length;i++){
                if(wcids[i]['id'].indexOf('c-')!=-1){
                    t.push(wcids[i]['id'].split('-')[1]);
                    t2.push(wcids[i]['label']);
                }
            }
            this.wcids=t;
            this.wcnames=t2.join(",");
            if(this.wcnames==''){
                this.wcnames='请选择'
            }
            that.equs=[]
            that.selectedEqus=[]
            const params = new URLSearchParams();
            params.append('wcids', this.wcids);
            axios.post('module/getEquipments.php',params).then(res=>{
                if(res.data.code==1){
                    that.equs=res.data.equs
                }
            })
            this.wcDlgVisible=false;            
        },
        handleCurrentChange(e){
            console.log(e,this.curpage)
            this.getAutoWorkRecords(this.curpage)
        },
        search(){
            let that=this
            this.getAutoWorkRecords(1)
        },
        getAutoWorkRecords(page){
            let that=this
            const params = new URLSearchParams();
            if(this.wcids!=null && this.wcids.length>0){
                params.append('wcids', this.wcids)
            }
            if(this.timeRange!=null && this.timeRange.length>0){
                params.append('startTime', moment(this.timeRange[0]).format("YYYY-MM-DD HH:mm:ss"))
                params.append('endTime', moment(this.timeRange[1]).format("YYYY-MM-DD HH:mm:ss"))
            }

            if(this.selectedEqus!=null && this.selectedEqus.length>0){
                let selectedEqus=this.selectedEqus.join("','")
                selectedEqus="'"+selectedEqus+"'"
                params.append("equNos",selectedEqus)
            }

            params.append("page",page)
            axios.post('module/getAutoWork.php',params).then(res=>{
                if(res.data.code==1){
                    that.tdata=res.data.tdata
                    that.curpage=res.data.cur_page
                    that.total=res.data.total
                    that.pageSize=res.data.pageSize
                    if(res.data.tdata!=null && res.data.tdata.length>0){
                        that.currentRow=res.data.tdata[0]
                        that.getDeviceData1(res.data.tdata[0].EquNo,res.data.tdata[0].WorkTime)
                    }
                }
            })
        },
        rowClick(row){
            let that=this
            this.currentRow=row
            that.getDeviceData1(row.EquNo,row.WorkTime)
        },
        rowStyle({row,col,rowIx,colIx}){
            let that=this
            if(row._id==this.currentRow._id){
                return {background:'orange'}
            }
        }
        
    }
})