
<?php

include_once('common/base.php');


function getWorkCenters()
{
    global $conn;
    $workcenters=array();
    $sql_workcenters = 'SELECT [CenterId],[CenterNo],[CenterName] FROM [dbo].[WorkCenter]   Order BY [dbo].[WorkCenter].[Sequence] ASC,[dbo].[WorkCenter].[CenterId] ASC';
    $stmt_workcenters=sqlsrv_query($conn, $sql_workcenters);
    if ($stmt_workcenters) {
        while ($row = sqlsrv_fetch_array($stmt_workcenters, SQLSRV_FETCH_ASSOC)) {
            $row['checked']=false;
            $workcenters[]=$row;
        }
        sqlsrv_free_stmt($stmt_workcenters);
    }

    return $workcenters;
}


if (isset($_POST['save'])) {
    $config2=array(
        "interval_left"=>$_POST['interval_left'],
        "interval_left_gap"=>$_POST['interval_left_gap'],
        "interval_devices_refresh"=>$_POST['interval_devices_refresh'],
        "interval_device_change"=>$_POST['interval_device_change'],
        "data_from_scada" => isset($_POST['data_from_scada'])?$_POST['data_from_scada']:'false',
		"curdev_dataget_period"=>isset($_POST['curdev_dataget_period'])?$_POST['curdev_dataget_period']:8,
        // "device_select_mode"=>$_POST['device_select_mode'],
        // "department_of_device"=>$_POST['department_of_device'],
        "workcenter_of_device"=>isset($_POST['workcenter_of_device'])?$_POST['workcenter_of_device']:null,
        "show_prospec"=>isset($_POST['show_prospec'])?$_POST['show_prospec']:'show',
        "show_device_name"=>isset($_POST['show_device_name'])?$_POST['show_device_name']:'show',
        "halt_time"=>isset($_POST['halt_time'])?$_POST['halt_time']:'2',
        "workcenters"=>isset($_POST['workcenter'])?$_POST['workcenter']:array(),
        //1:仅查今日 2:看3日计划 3:查本周计划 4:查本月计划
        "plan_search_mode"=>$_POST['plan_search_mode'],
        //1:仅查今日 2:查本周计划 3:查本月计划
        "defect_search_mode"=>$_POST['defect_search_mode'],
        //参数设置
        "parameters"=>array(
            //效率预警kpi
            "efficient_kpi_boundary"=>$_POST['efficient_kpi'],
            "qualityrate_kpi_boundary"=>$_POST['qualityrate_kpi'],
            //达成率预警kpi
            //"achieving_rate_boundary"=>$_POST['achieving_rate'],
            //今日目标预警kpi
            "kpi_std_output"=>$_POST['kpi_std_output'],
            //看板名称
            "ekb_name"=>$_POST['ekbname'],
            //看板子名称
            'sub_ekb_name' =>$_POST['sub_ekb_name']
        ),
		'fullscreen_page_change'=>'1',//全屏模式设备翻页周期
        //'sp_achieving_rate'=>$_POST['sp_achieving_rate'],
        //'sp_qualified_rate'=>$_POST['sp_qualified_rate'],
        //'sp_current_workcenter'=>$_POST['sp_current_workcenter'],
    );


    file_put_contents('config.json', json_encode($config2));
    $config=array_merge($config, $config2);

    $save_success=true;
}

$workcenters=array();
$workcenters=getWorkCenters();


?>

<!doctype html>
<html>
	<head>
		<title>看板配置</title>
		<meta charset="utf-8" />
		<link rel="stylesheet" type="text/css" href="static/layui/css/layui.css"/>
		<link rel="stylesheet" type="text/css" href="static/css/config.css"/>	
		<script src="static/layui/layui.js" ></script>
		<script src="static/js/config.js" ></script>		
	</head>	
	<body>
		<div class="layui-container ">
			<div class="layui-row header">
				<div class="layui-col-md12">
					<h1><?php echo $config['company']['name'];?>看板系统配置</h1>
				</div>
			</div>
			<div class="layui-row main">
				<?php if (isset($save_success) && $save_success==true): ?>
					<div class="info">保存成功</div>
				<?php endif; ?>
				<form action="" method="post"  class="layui-form layui-form-pane">
					  <div class="layui-form-item">
						<label class="layui-form-label tlt-label">工作站（右边）</label>
						<div class="layui-input-block tlt-input-block " id="workcenter_of_device"> 
								<?php foreach ($workcenters as $workcenter):?>
									<input type="checkbox" name="workcenter_of_device[]" value="<?php  echo $workcenter['CenterId']; ?>"  title="<?php echo $workcenter['CenterName']; ?>"  <?php if (in_array($workcenter['CenterId'], $config['workcenter_of_device'])) {
    echo 'checked';
}  ?> />
								<?php endforeach; ?>
						</div>
					  </div>
					  <div class="layui-form-item">
						<label class="layui-form-label tlt-label">是否显示设备名</label>
						<div class="layui-input-block tlt-input-block " id="show_device_name" style="display:flex;"> 
							<select name="show_device_name" lay-filter="show_device_name">
									<option value="show" <?php if ($config['show_device_name']=='show') {
    echo 'selected';
} ?>>显示</option>
									<option value="hide" <?php if ($config['show_device_name']=='hide') {
    echo 'selected';
} ?>>隐藏</option>
								</select> 
						</div>
					  </div>
					  <div class="layui-form-item">
						<label class="layui-form-label tlt-label">是否显示规格</label>
						<div class="layui-input-block tlt-input-block " id="show_prospec" style="display:flex;"> 
							<select name="show_prospec" lay-filter="show_prospec">
									<option value="show" <?php if ($config['show_prospec']=='show') {
    echo 'selected';
} ?>>显示</option>
									<option value="hide" <?php if ($config['show_prospec']=='hide') {
    echo 'selected';
} ?>>隐藏</option>
								</select> 
						</div>
					  </div>					  					  				  
					  <div class="layui-form-item">
						<label class="layui-form-label tlt-label">完工站（左）</label>
						<div class="layui-input-block tlt-input-block " id="workcenters"> 
							<?php foreach ($workcenters as $workcenter):?>
									<input type="checkbox" name="workcenter[]" value="<?php  echo $workcenter['CenterId']; ?>"  title="<?php echo $workcenter['CenterName']; ?>"  <?php if (in_array($workcenter['CenterId'], $config['workcenters'])) {
    echo 'checked';
}  ?> />
								<?php endforeach; ?>

						</div>
					  </div>
					  <div class="layui-form-item">
						<label class="layui-form-label tlt-label">柱状图横坐标间隔</label>
						<div class="layui-input-block tlt-input-block " id="interval_left_gap" style="display:flex;"> 
							<select name="interval_left_gap" lay-filter="interval_left_gap">
									<option value="5" <?php if ($config['interval_left_gap']=='5') {
    echo 'selected';
} ?>>5分钟</option>
									<option value="10" <?php if ($config['interval_left_gap']=='10') {
    echo 'selected';
} ?>>10分钟</option>
									<option value="15" <?php if ($config['interval_left_gap']=='15') {
    echo 'selected';
} ?>>15分钟</option>
									<option value="20" <?php if ($config['interval_left_gap']=='20') {
    echo 'selected';
} ?>>20分钟</option>
									<option value="25" <?php if ($config['interval_left_gap']=='25') {
    echo 'selected';
} ?>>25分钟</option>
									<option value="30" <?php if ($config['interval_left_gap']=='30') {
    echo 'selected';
} ?>>30分钟</option>
								</select> 
						</div>
					  </div>					  
					  <div class="layui-form-item">
						<label class="layui-form-label tlt-label">取数来源</label>
						<div class="layui-input-block tlt-input-block "  style="display:flex;">				
							<select name="data_from_scada" lay-filter="data_from_scada">
								<option value="false" <?php if ($config['data_from_scada']=='false') {
    echo 'selected';
} ?>>来自非SCADA</option>
								<option value="true" <?php if ($config['data_from_scada']=='true') {
    echo 'selected';
} ?>>来自SCADA</option>
							</select> 
						</div>
					  </div>						  
					  <div class="layui-form-item">
						<label class="layui-form-label tlt-label">计划查询模式</label>
						<div class="layui-input-block tlt-input-block ">
							<select name="plan_search_mode" lay-verify="">
								<option value="1" <?php if ($config['plan_search_mode']==1) {
    echo 'selected';
} ?> >仅查当日</option>
								<option value="2" <?php if ($config['plan_search_mode']==2) {
    echo 'selected';
} ?> >3日计划</option>
								<option value="3" <?php if ($config['plan_search_mode']==3) {
    echo 'selected';
} ?> >本周计划</option>
								<option value="4" <?php if ($config['plan_search_mode']==4) {
    echo 'selected';
} ?> >本月计划</option>
							</select>
						</div>
					  </div>
					  <div class="layui-form-item">
						<label class="layui-form-label tlt-label">缺陷状况时间设置</label>
						<div class="layui-input-block tlt-input-block ">
							<select name="defect_search_mode" lay-verify="">
								<option value="1" <?php if ($config['defect_search_mode']==1) {
    echo 'selected';
} ?> >仅查当日</option>
								<option value="2" <?php if ($config['defect_search_mode']==2) {
    echo 'selected';
} ?> >本周计划</option>
								<option value="3" <?php if ($config['defect_search_mode']==3) {
    echo 'selected';
} ?> >本月计划</option>
							</select>
						</div>
					  </div>
					  <div class="layui-form-item">					  
						<label class="layui-form-label tlt-label">停机时间判断基准</label>
						<div class="layui-input-inline tlt-input-inline ">
							<div class="left-text"></div><input type="text" name="halt_time" autocomplete="off" class="layui-input" value="<?php echo isset($config['halt_time'])?$config['halt_time']:'2'?>" style="width:30px;" ><div class="right-text">分钟</div>
						</div>
					  </div>					  					  
					  <div class="layui-form-item">					  
						<label class="layui-form-label tlt-label">数据刷新周期（左）</label>
						<div class="layui-input-inline tlt-input-inline ">
							<div class="left-text">按</div><input type="text" name="interval_left" autocomplete="off" class="layui-input" value="<?php echo isset($config['interval_left'])?$config['interval_left']:'2'?>" style="width:30px;" ><div class="right-text">分钟间隔读取</div>
						</div>
					  </div>
					  <div class="layui-form-item">					  
						<label class="layui-form-label tlt-label">设备列表刷新周期（右）</label>
						<div class="layui-input-inline tlt-input-inline ">
							<div class="left-text">按</div><input type="text" name="interval_devices_refresh" autocomplete="off" class="layui-input" value="<?php echo isset($config['interval_devices_refresh'])?$config['interval_devices_refresh']:'2'?>" style="width:30px;" ><div class="right-text">分钟间隔读取</div>
						</div>
					  </div>
					  <div class="layui-form-item">					  
						<label class="layui-form-label tlt-label">全屏模式设备翻页周期</label>
						<div class="layui-input-inline tlt-input-inline ">
							<div class="left-text">按</div><input type="text" name="fullscreen_page_change" autocomplete="off" class="layui-input" value="<?php echo isset($config['fullscreen_page_change'])?$config['fullscreen_page_change']:'1'?>" style="width:30px;" ><div class="right-text">分钟间隔读取</div>
						</div>
					  </div>					  
					  <div class="layui-form-item">					  
						<label class="layui-form-label tlt-label">当前设备切换周期</label>
						<div class="layui-input-inline tlt-input-inline ">
							<div class="left-text">按</div><input type="text" name="interval_device_change" autocomplete="off" class="layui-input" value="<?php echo isset($config['interval_device_change'])?$config['interval_device_change']:'10' ?>" style="width:30px;" ><div class="right-text">秒间隔读取</div>
						</div>
					  </div>	
					  <div class="layui-form-item">					  
						<label class="layui-form-label tlt-label">当前设备取数时间</label>
						<div class="layui-input-inline tlt-input-inline ">
							<div class="left-text">最近</div><input type="text" name="curdev_dataget_period" autocomplete="off" class="layui-input" value="<?php echo isset($config['curdev_dataget_period'])?$config['curdev_dataget_period']:'8' ?>" style="width:30px;" ><div class="right-text">小时</div>
						</div>
					  </div>						  				  
					  <div class="layui-form-item">					  
						<label class="layui-form-label tlt-label">效率预警KPI值</label>
						<div class="layui-input-block tlt-input-block ">
							<input type="text" name="efficient_kpi" autocomplete="off" class="layui-input" value="<?php echo $config['parameters']['efficient_kpi_boundary']?>"   />
						</div>
					  </div>	
					  <div class="layui-form-item">					  
						<label class="layui-form-label tlt-label">良率KPI值</label>
						<div class="layui-input-block tlt-input-block ">
							<input type="text" name="qualityrate_kpi" autocomplete="off" class="layui-input" value="<?php echo $config['parameters']['qualityrate_kpi_boundary']?>"  />
						</div>
					  </div>
					  <div class="layui-form-item">					  
						<label class="layui-form-label tlt-label">标准产量KPI</label>
						<div class="layui-input-block tlt-input-block ">
							<input type="text" name="kpi_std_output" autocomplete="off" class="layui-input" value="<?php if (isset($config['parameters']['kpi_std_output'])) {
    echo $config['parameters']['kpi_std_output'];
}?>"   />
						</div>
					  </div>		
					  <div class="layui-form-item">					  
						<label class="layui-form-label tlt-label">看板名称</label>
						<div class="layui-input-block tlt-input-block ">
							<input type="text" name="ekbname" autocomplete="off" class="layui-input" value="<?php echo $config['parameters']['ekb_name']?>" />
						</div>
					  </div>
					  <div class="layui-form-item">					  
						<label class="layui-form-label tlt-label">看板子名称</label>
						<div class="layui-input-block tlt-input-block ">
							<input type="text" name="sub_ekb_name" autocomplete="off" class="layui-input" value="<?php echo isset($config['parameters']['sub_ekb_name'])?$config['parameters']['sub_ekb_name']:''?>" />
						</div>
					  </div>

					  <input class="layui-btn layui-btn-fluid layui-btn-primary" name="save" type="submit" value="保存">
				</form>
			</div>
			
			<div class="layui-row footer">
				<div class="layui-col-md12">
					<!--<h1><?php echo $config['company']['info'];?>看板系统配置</h1>-->
				</div>							
			</div>
		</div>

	</body>



</html>