<?php

require_once 'rsa.php';
require_once 'hardware.php';

session_start();
$sid=session_id();
$authSuc=false;

if(isset($_POST['code'])){

	file_put_contents('../auth/code.key',HardwareInfo::getMCode()."\r\n");
	header( "Content-type: text/plain;charset=utf-8"); 
	header( "Accept-Ranges:  bytes "); 
	header( "Accept-Length: " .filesize('../auth/code.key'));
	header( "Content-Disposition:  attachment;  filename= ekb.mcode"); 
	
	readfile('../auth/code.key');unlink('../auth/code.key'); die();

}else if(isset($_POST['auth_code'])){
	
	$fid=$_POST['auth_code'];
	//auth_code 授权文件名
	//授权文件不存在，跳转
	if(!file_exists('/auth/certs/'.$_POST['auth_code'].'.key')){
		echo '授权失败，正在跳转';
		echo '<script>setTimeout(function(){window.location=\'auth.php\';},1500);</script>';
		die();			
	}


	//解密文件
	$data=trim(file_get_contents('/auth/certs/'.$_POST['auth_code'].'.key'));
	$data=explode("\r\n",$data);
	$mcode=HardwareInfo::getMCode();

	//机器码不相等，该授权文件不是针对该机器的	
	if($mcode!=Rsa::privDecrypt(trim($data[1]))){
		echo '授权失败，正在跳转';
		echo '<script>setTimeout(function(){window.location=\'auth.php\';},1500);</script>';
		die();			
	}
	
	//GUID值
	$authData=trim($data[0]);
	$authData=Rsa::privDecrypt($authData);		
	$authData=json_decode($authData,true);	
	if($authData!=NULL && isset($authData['uuid'])){
		$authSuc=true;		
	}else{
		echo '授权失败，正在跳转';
		echo '<script>setTimeout(function(){window.location=\'auth.php\';},1500);</script>';
		die();		
	}

	$guid=$authData['uuid'];

	//添加认证用户
	//读取锁文件
	$ttime=time();
	$flag=false;
	if(file_exists('/auth/tmp/'.$guid)){
		$lock=file_get_contents('/auth/tmp/'.$guid);
		$lock=explode("\n",$lock);		
		foreach($lock as $k=>$v){
			if($v!=""){
				$row=Rsa::privDecrypt(trim($v));
				$row=explode('::',$row);
				$id=$row[0];//guid
				if($id==$authData['uuid']){
					//判断sid是不是一致,不一致判断$row
					if($sid!=$row[1]){
						//大于一分钟，表明上一个用户非活跃状态
						if($ttime-$row[2]<60){
							echo '授权失败，已有授权用户处于活跃状态，一次只能授权一位，请一分钟后再尝试';
							echo '<script>setTimeout(function(){window.location=\'auth.php\';},1500);</script>';
							die();								
						}
					}
					$flag=true;
					$lock[$k]=Rsa::publicEncrypt($id.'::'.$sid.'::'.$ttime);
					$lock=implode("\n",$lock);
					file_put_contents('/auth/tmp/'.$guid,$lock);
					break;
				}
			}
		}
	}
	if($flag==false){
		file_put_contents('/auth/tmp/'.$guid,"\n".Rsa::publicEncrypt($authData['uuid'].'::'.$sid.'::'.time()),FILE_APPEND);
	}
	
	//设置cookie远不过期
	setcookie(session_name(),$sid,time()+10*365*24*3600);
	setcookie('fid',Rsa::privEncrypt($_POST['auth_code']),time()+10*365*24*3600);
	setcookie('guid',Rsa::privEncrypt($authData['uuid']),time()+10*365*24*3600);
	echo '授权成功，正在跳转';
	echo '<script>setTimeout(function(){window.location=\'index.php\';},1500);</script>';
	die();
}


?>

<html>
	<head>
	
	</head>
	
	<body>
		<form method="post" enctype="multipart/form-data">
			<input type="text" name="auth_code" placeholder="请输入授权码"/>
			<button type="submit" >授权</button>
			<button type="submit" name="code">生成机器码</button>
		</form>
	
	</body>

</html>