let appCnc=new Vue({
    data(){
        return {          
            curDeviceName:'',
            autorun:0,
            autorun2:'0%',
            autostop:0,
            autostop2:'0%',
            prepare:0,
            prepare2:'0%',
            warntime:0,
            warntime2:'0%',
            closetime:0,
            closetime2:'0%',         
            totalDevicesNum:0,
            runDevicesNum:0,
            stopDevicesNum:0,
            failDevicesNum:0,
            blackoutDevicesNum:0,
            curDeviceIx:0,
            autorun:0,
            autostop:0,
            getDeviceData1Handle:null,
            getDeviceData2Handle:null,
            machineId:'',
            cncStatus:'',
            mainPrgmName:'',
            toolNumber:'',
            spindleLoad:'',
            actFeed:'',
            actSpindle:'',
            overSpindle:'',
            alarmMsgs:[],
            ...commonOption,
            equNo:'',
            countDownSec:15,
            countDownHandle:null
        }
    },
    created(){
        
    },
    mounted(){
        let that=this       
    },
    computed:{
        cncStatusx(){
            let that=this
            
            if(this.cncStatus==null || 
            this.cncStatus=='' 
                ||this.cncStatus==undefined
            ){
                return ''
            }
            
            if(this.cncStatus=='AUTO_RUN'){
                return '运行中'
            }

            if(this.cncStatus=='OFF'){
                return '停机'
            }
            
            if(this.cncStatus=='EMERGENCY'){
                return '急停'
            }

            if(this.cncStatus.indexOf('MANUAL')>=0){
                return '手动'
            }

            return ''
            
        }
    },
    methods:{
        show(){
            let that=this          
            this.$el.style.display='block'
            this.countDownSec=30
            that.countDown()
            this.$nextTick(()=>{
                // const loading=this.$loading({
                //     lock: true,
                //     text: '加载中',
                //     spinner: 'el-icon-loading',
                //     background: 'rgba(0, 0, 0, 0.7)'
                // }); 
                let p1=that.getDeviceData1(this.machineId)
                let p2=that.getDeviceData2(this.equNo)
                Promise.all([p1,p2]).catch((err)=>{
                    console.log(err)
                }).then(res=>{
                    // loading.close()
                })
            })

        },
        back(){

            // clearTimeout(this.getDeviceData1Handle)
            // clearTimeout(this.getDeviceData2Handle)
            clearTimeout(this.countDownHandle)
            this.$el.style.display='none'
            // let lastApp=appStack[appStack.length-1]
            // lastApp.show()

        },
        countDown(){
            let that=this
            that.countDownHandle=setTimeout(function(){
                if(that.$el.style.display=='none'){
                    return
                }
                that.countDownSec--
                if(that.countDownSec>0){
                    that.countDown()
                }else{
                    that.back()
                }
            },1000)
        },
        init(option){
            let that=this
            for(let i in option){
                this[i]=option[i]
            }
        },
        getDeviceData1(machineId){
            let that=this 
            return axios.get('module/getMDC.php',{params:{machineId:machineId}}).then(res=>{
                if(res.data.code==1){
                    let statusesConfig={
                        AUTO_RUN:{
                            color:'#0b5f01',
                            label:'工作'
                        },
                        OFF:{
                            color:'#ababab',
                            label:'停机'
                        },
                        WAIT:{
                            color:'#a38c14',
                            label:'待机'
                        },                            
                        EMERGENCY:{
                            color:'#ff0000',
                            label:'急停'
                        },
                        MANUAL:{
                            color:'#377aab',
                            label:'手动'
                        }                                                                                  
                    }
                    that.machineId=res.data.data.machineId;
                    that.cncStatus=res.data.data.cncStatus;
                    that.mainPrgmName=res.data.data.mainPrgmName;
                    that.toolNumber=res.data.data.toolNumber;
                    that.spindleLoad=res.data.data.spindleLoad;
                    that.actFeed=res.data.data.actFeed;
                    that.actSpindle=res.data.data.actSpindle;
                    that.overSpindle=res.data.data.overSpindle;                    
  
                    let statusesAutoWork=res.data.data.cncStatuses.filter((e)=>{
                       return e[3]=='AUTO_RUN'
                    })
                    let statusesOff=res.data.data.cncStatuses.filter((e)=>{
                       return e[3]=='OFF'
                    })
                    let statusesWait=res.data.data.cncStatuses.filter((e)=>{
                       return e[3]=='WAIT'
                    })
                    let statusesEmergency=res.data.data.cncStatuses.filter((e)=>{
                       return e[3]=='EMERGENCY'
                    })
                    let statusesManual=res.data.data.cncStatuses.filter((e)=>{
                       return e[3]=='MANUAL'
                    })

                    let renderFun=function (params, api) {

                        let startPoint=api.coord([api.value(0),1])
                        let endPoint=api.coord([api.value(2),0])
                        let status=api.value(3)
                        let fillColor=statusesConfig[status].color
                        return {
                            type: 'rect',
                            shape: {
                                x: startPoint[0],
                                y: startPoint[1],
                                width: endPoint[0]-startPoint[0],
                                height: api.size([0,1])[1]
                            },
                            style:api.style({
                                fill:fillColor
                            })
                        };
                    }

                    that.$nextTick(()=>{
                        let myChart3 = echarts.init(that.$refs.chartFsCnsStatus1);                          
                            option3 = {
                                title: {
                                    text: '机台状态',
                                    textStyle:{
                                        color:'#fff'
                                    }
                                },
                                tooltip: {
                                    trigger:'item',
                                    formatter:function(params){
                                       let status=params.data[3]
                                       let st=params.data[0]
                                       let en=params.data[2]
                                       if(statusesConfig[status]!=null){
                                            let html='<ul>'
                                                html+='<li>'
                                                html+=statusesConfig[status].label
                                                html+='</li>'
                                                html+='<li>'
                                                html+=st
                                                html+='</li>'
                                                html+='<li>'
                                                html+=en
                                                html+='</li>'                                                                                                
                                                html+='</ul>'
                                            return html
                                       }else{
                                            return '不支持的类型'
                                       }
                                       
                                    }
                                },
                                grid:[
                                    {
                                        left:0,
                                        right:0
                                    }
                                ],
                                xAxis: {
                                    type:'time',
                                    scale: true,
                                    axisLabel:{
                                        formatter:function(value){
                                            return moment(value).format("HH")+'时'
                                        }
                                    },
                                    max:'dataMax'
                                },
                                legend:{
                                    data:[
                                        {
                                            name:'工作',
                                            icon:'rect',
                                            itemStyle:{
                                                color:'#0b5f01'
                                            }
                                        },
                                        {
                                            name:'停机',
                                            icon:'rect',
                                            itemStyle:{
                                                color:'#ababab'
                                            }
                                        },
                                        {
                                            name:'待机',
                                            icon:'rect',
                                            itemStyle:{
                                                color:'#a38c14'
                                            }
                                        },
                                        {
                                            name:'急停',
                                            icon:'rect',
                                            itemStyle:{
                                                color:'#ff0000'
                                            }
                                        },
                                        {
                                            name:'手动',
                                            icon:'rect',
                                            itemStyle:{
                                                color:'#377aab'
                                            }
                                        }
                                    ]
                                },
                                yAxis: {
                                    show:false,
                                    max:1
                                },
                                series: [
                                    {
                                        type: 'custom',
                                        name:'工作',
                                        renderItem: renderFun,
                                        data: statusesAutoWork
                                    },
                                    {
                                        type: 'custom',
                                        name:'停机',
                                        renderItem: renderFun,
                                        data: statusesOff
                                    },
                                    {
                                        type: 'custom',
                                        name:'待机',
                                        renderItem: renderFun,
                                        data: statusesWait
                                    },
                                    {
                                        type: 'custom',
                                        name:'急停',
                                        renderItem: renderFun,
                                        data: statusesEmergency
                                    },
                                    {
                                        type: 'custom',
                                        name:'手动',
                                        renderItem: renderFun,
                                        data: statusesManual
                                    }
                                ]
                            };

                            myChart3.setOption(option3);  
                            myChart3.resize();
                        let myChart4 = echarts.init(this.$refs.chartFsOverFeed1);    
                        let option4 = {
                                    title:{
                                        text:'进给倍率',
                                        textStyle:{
                                            color:'#fff'
                                        }
                                    },      
  
                                    series: [
                                        {
                                            type: 'gauge',
                                            radius:'40%',
                                            min:0,
                                            max:180,  
                                            startAngle:180,
                                            endAngle:-0,  
                                            axisLine: {
                                                lineStyle: {
                                                    width: 10,
                                                    color: [
                                                        [res.data.data.overFeed/180,'rgb(33, 150, 243)'],
                                                        [1,'#ffffff']
                                                    ]
                                                }
                                            }, 
                                            pointer:{
                                                show:false
                                            },
                                            axisLabel:{
                                                show:false
                                            },
                                            splitLine:{
                                                show:false
                                            },
                                            axisTick:{
                                                show:false
                                            },                                                                                                            
                                            detail: {
                                                valueAnimation: true,
                                                formatter: '{value}',
                                                color: 'white',
                                                fontSize:12,
                                                offsetCenter:[0,'80%'],
                                            },
                                            data: [{
                                                value:res.data.data.overFeed
                                            }]
                                        }                                  
                                    ]
                                };
                                myChart4.setOption(option4);         
                                myChart4.resize();
                        let myChart5 = echarts.init(this.$refs.chartFsOverSpindle1);   
                        let option5 = {
                                    title:{
                                        text:'主轴倍率',
                                        textStyle:{
                                            color:'#fff'
                                        }
                                    },      
  
                                    series: [
                                        {
                                            type: 'gauge',
                                            radius:'40%',
                                            min:0,
                                            max:180,  
                                            startAngle:180,
                                            endAngle:-0,  
                                            axisLine: {
                                                lineStyle: {
                                                    width: 10,
                                                    color: [
                                                        [res.data.data.overSpindle/180,'rgb(33, 150, 243)'],
                                                        [1,'#ffffff']
                                                    ]
                                                }
                                            }, 
                                            pointer:{
                                                show:false
                                            },
                                            axisLabel:{
                                                show:false
                                            },
                                            splitLine:{
                                                show:false
                                            },
                                            axisTick:{
                                                show:false
                                            },                                                                                                            
                                            detail: {
                                                valueAnimation: true,
                                                formatter: '{value}',
                                                color: 'white',
                                                fontSize:12,
                                                offsetCenter:[0,'80%'],
                                            },
                                            data: [{
                                                value:res.data.data.overSpindle
                                            }]
                                        }                                  
                                    ]
                                };
                                myChart5.setOption(option5);                                        
                                myChart5.resize();

                            })
 

               
               
                }else{

                }

            }).catch(err=>{
                console.log(err)
            }).then((res)=>{
                // that.getDeviceData1Handle=setTimeout(function(){
                //     that.getDeviceData1(machineId)
                // },30*1000)
            })
        },
        getDeviceData2(equNo){
            let that=this
            return axios.get('module/getCurDeviceInfo.php',{
                params:{
                    equNo:equNo,
                    starttime:this.starttime.getTime()/1000,
                    endtime:this.endtime.getTime()/1000                       
                }
            }).then((res)=>{
                
                that.autorun=res.data.autoRun;
                that.autorun2=res.data.autoRun2;
                that.autostop=res.data.autoStop;
                that.autostop2=res.data.autoStop2;
                that.warntime=res.data.warnTime;
                that.warntime2=res.data.warnTime2;
                that.closetime=res.data.closeTime;
                that.closetime2=res.data.closeTime2;
                that.prepare=res.data.prepare;
                that.prepare2=res.data.prepare2;
                that.$nextTick(()=>{
                        try{
                            let myChart = echarts.init(that.$refs.chartFsOutput1);
                            let option = {
                                    title:{
                                        text:'',
                                        textStyle:{
                                            color:'#fff'
                                        },
                                        top:'10%',
                                        left:'10%'
                                    },
                                    tooltip:{
                                        show:true,
                                        trigger: 'axis'
                                    },
                                    legend:{
                                        show:false,
                                        data:['产量'],
                                        icon:'rect',
                                        right:10,
                                        top:'45%',
                                        type: 'scroll',
                                        orient: 'vertical',
                                        itemHeight:10,
                                        textStyle:{
                                            color:'white',
                                            fontSize:'16px'
                                        }
                                    },
                                    grid: [{
                                    left: '10%',
                                    bottom: '18%',
                                    top: '23%',
                                    right: '20%'
                                    }],                                       
                                    xAxis: {
                                        type: 'category',
                                        data: res.data.timeline,
                                        splitNumber:8,
                                        axisLabel:{show:true,color:'#fff',rotate:45}
                                    },
                                    yAxis: [{
                                        type: 'value',
                                        name:'产量',
                                        nameTextStyle:{
                                            color:'#fff'
                                        },
                                        splitLine:{
                                            show:false
                                        },
                                        axisLabel:{show:true,color:'#fff'},
                                        axisLine:{
                                            show:true
                                        }
                                    }],                         
                                    series: [
                                        {
                                            name: '产量',
                                            type: 'bar',
                                            smooth: true,
                                            // symbol:'none',
                                            color:['#0d7334'],
                                            data: res.data.outputs,
                                            yAxisIndex:0
                                        }
                                    ]
                                };
                                myChart.setOption(option);

                            let myChart2 = echarts.init(that.$refs.chartFs24RunRate1); 
                            let option2 = {
                                    title:{
                                        text:'',
                                        textStyle:{
                                            color:'#fff'
                                        },
                                        top:'10%',
                                        left:'10%'
                                    },
                                    tooltip:{
                                        show:true,
                                        trigger: 'axis'
                                    },
                                    legend:{
                                        show:true,
                                        data:['运转率'],
                                        icon:'rect',
                                        right:10,
                                        top:'45%',
                                        type: 'scroll',
                                        orient: 'vertical',
                                        itemHeight:10,
                                        textStyle:{
                                            color:'white',
                                            fontSize:'16px'
                                        }
                                    },
                                    grid: [{
                                    left: '10%',
                                    bottom: '18%',
                                    top: '23%',
                                    right: '20%'
                                    }],                                       
                                    xAxis: {
                                        type: 'category',
                                        data: res.data.timeline,
                                        splitNumber:8,
                                        axisLabel:{show:true,color:'#fff',rotate:45}
                                    },
                                    yAxis: [{
                                        type: 'value',
                                        name:'运转率(%)',
                                        nameTextStyle:{
                                            color:'#fff'
                                        },
                                        splitLine:{
                                            show:false
                                        },
                                        axisLabel:{show:true,color:'#fff',formatter:(v)=>v*100},
                                        axisLine:{
                                            show:true
                                        }
                                    }],                         
                                    series: [
                                        {
                                            name: '开动率',
                                            type: 'line',
                                            smooth: true,
                                            color:['#cb0000'],
                                            data: res.data.runrates,
                                            yAxisIndex:0
                                        }
                                    ]
                                };
                                myChart2.setOption(option2);                        

                        
               
                        
                        
                        }catch(e){
                            console.log(e,that.$refs)
                        }
                    })
            }).catch(err=>{
                console.log(err)
            }).then(res=>{
                // that.getDeviceData2Handle=setTimeout(() => {
                //     that.getDeviceData2(equNo)
                // }, 30*1000);
            })              
        }
        
    }
})