function getDeviceInfo(equNo){
    let that=this
    return axios.get('module/getCurDeviceInfo.php',{
        params:{
            equNo:equNo,
            starttime:this.starttime.getTime()/1000,
            endtime:this.endtime.getTime()/1000                       
        }
    })                
}



class TimeoutManager{

    constructor(){
        this.timeoutObjects=new Array()
    }

    getTimeoutObject(){
        let o=new TimeoutObject()
        this.timeoutObjects.push(o)
        return o
    }

    clearTimeout(){  
        this.timeoutObjects
        .forEach((v,i)=>{
            v.clearTimeout()
        })
    }
}

class TimeoutObject{

    constructor(){
        this.cancelFlag=null
        this.timeoutHandle=null
    }

    setTimeout(f,t){
        if(this.cancelFlag!=null){
            return
        }
        this.timeoutHandle=setTimeout(function(){
            if(this.cancelFlag!=null){
                f();
            }
        },t)

    }

    clearTimeout(){
        clearTimeout(this.timeoutHandle)
        this.cancelFlag=true
    }

}