class TimeoutManager{

    constructor(){
        this.timeoutObjects=new Array()
    }

    getTimeoutObject(){
        let o=new TimeoutObject()
        this.timeoutObjects.push(o)
        return o
    }

    clearTimeout(){  
        this.timeoutObjects
        .forEach((v,i)=>{
            v.clearTimeout()
        })
    }

    reset(){
        this.timeoutObjects
        .forEach((v,i)=>{
            v.reset()
        })
    }
}

class TimeoutObject{
    constructor(){
        this.cancelFlag=null
        this.timeoutHandle=null
    }

    setTimeout(f,t){
        if(this.cancelFlag!=null){
            return
        }
        this.timeoutHandle=setTimeout(function(){
            if(this.cancelFlag!=null){
                f();
            }
        },t)

    }

    clearTimeout(){
        clearTimeout(this.timeoutHandle)
        this.cancelFlag=true
    }

    reset(){
        this.cancelFlag=null
    }

}